/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008-2010 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#include <QApplication>
#include <QTextStream>
#include <QDomDocument>

#include <cassert>

#include "FileLoaderIAC.h"
#include "Util.h"
#include "Version.h"
#include "sha1/sha1.h"

//-------------------------------------------------------------------------------
FileLoaderIAC::FileLoaderIAC()
{
    step = 0;
    
    idFileIAC = -1;    // id des requêtes à -1, car ev. reçu lors du "setHost()"
    fileLoaded = false;
    
    zygriblog = "a07622b82b18524d2088c9b272bb3feeb0eb1737";
    zygribpwd = "61c9b2b17db77a27841bbeeabff923448b0f6388";
    
    http = new QHttp(this);
    assert(http);

	host = "www.zygrib.org";
	
    http->setHost(host);

    connect(http, SIGNAL(done(bool)), this, SLOT(slotDone(bool)));

    connect(http, SIGNAL(requestFinished (int, bool)),
            	this, SLOT(requestFinished (int, bool)));
            	
    connect(http, SIGNAL(dataReadProgress (int, int)),
            	this, SLOT(dataReadProgress (int, int)));
}
//-------------------------------------------------------------------------------
FileLoaderIAC::~FileLoaderIAC () {
    if (http != NULL)
        delete http;
}

//-------------------------------------------------------------------------------
void FileLoaderIAC::stop () {
    http->abort();
}

//-------------------------------------------------------------------------------
void FileLoaderIAC::dataReadProgress (int done , int  total)
{
	//printf("dataReadProgress: %d %d\n", done, total);
    emit signalIACreadProgress(step, done, total);
}

//-------------------------------------------------------------------------------
void FileLoaderIAC::getFile(FileModeIAC IACmode)
{
    QString page;

    if (ioBuffer.isOpen()) {
        ioBuffer.close();
    }
    
    //----------------------------------------------------------------
    // Etape 1 : Demande la création du fichier IAC
    //----------------------------------------------------------------
    fileLoaded = false;
        
        if (Util::getSetting("httpUseProxy", false).toBool())
        {
            http->setProxy(
                Util::getSetting("httpProxyHostname", "").toString(),
                Util::getSetting("httpProxyPort", 0).toInt(),
                Util::getSetting("httpProxyUsername", "").toString(),
                Util::getSetting("httpProxyUserPassword", "").toString()
            );
        }
        else {
            http->setProxy("",0,"","");
        }
        
        step = 1;
        emit signalIACsendMessage(tr("Make file on server"));
        
        emit signalIACreadProgress(step, 0, 0);
        
        if (IACmode == ANALYSE_FILE) {
			QTextStream(&page) << "/noaa/getNoaaIacFile.php?"
							<< "but=analyse"
							<< "&client=" << Version::getCompleteName()
							;
		}
        else {   // if (IACmode == FORECAST_FILE) {
			QTextStream(&page) << "/noaa/getNoaaIacFile.php?"
							<< "but=forecast"
							<< "&client=" << Version::getCompleteName()
							;
		}
//printf("p=%s\n", qPrintable(page));
        ioBuffer.close();
        ioBuffer.setBuffer(NULL);
        idFileIAC = http->get(page, &ioBuffer);
//printf("idFileIAC=%d\n", idFileIAC);
    // Suite de la séquence de récupération dans requestFinished()
}

//-------------------------------------------------------------------------------
void FileLoaderIAC::requestFinished ( int id, bool error )
{
	//printf("requestFinished id=%d error=%d\n", id,error);
    QString page;
    if (error) {
        emit signalIACloadError(http->errorString());
    }
    else if (id==idFileIAC && !fileLoaded)
    {
		fileLoaded = true;
	}
}

//-------------------------------------------------------------------------------
void FileLoaderIAC::slotDone (bool error)
{
	if (! fileLoaded  || error)
		return;
		
	arrayContent = ioBuffer.buffer();
	if (arrayContent.size() == 0)
		return;

	QHttpResponseHeader header = http->lastResponse();
	if (header.isValid())
	{
		// Look for header entry:
		//     "content-disposition : attachment; filename=FSXX21_251200_20081125"
		QString hval = header.value("content-disposition");

		// Extract file name from : "attachment; filename=FSXX21_251200_20081125"
		int ind = hval.lastIndexOf('=');
		if (ind > 0)
			fileName = hval.right( hval.size()-ind-1 );
		else
			fileName = "IACfile";
	}

	emit signalIACsendMessage(tr("Finish"));
	emit signalIACdataReceived(&arrayContent, fileName);
}


