/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#ifndef METEOTABLEOPTIONSDIALOG_H
#define METEOTABLEOPTIONSDIALOG_H

#include <QDialog>
#include <QFrame>
#include <QGridLayout>
#include <QLabel>
#include <QCheckBox>
#include <QComboBox>
#include <QPushButton>
#include <QButtonGroup>
#include <QRadioButton>
#include <QLineEdit>
#include <QDoubleSpinBox>

#include "GUI/ui_MeteotableOptionsDialog.h"

class DialogMeteotableOptions
		: public QDialog,
		  private Ui_MeteotableOptionsDialog
{ Q_OBJECT
    public:
        DialogMeteotableOptions ();
    
    public slots:
        void slotBtOK ();
        void slotBtCancel ();
        void slotChangeVisibleItems ();
    
    
    private:
		// setting (bool) : data visible or not in meteotable
        QString getSettingName_vis(uint gribCode) {
			return QString("MTableData_vis_%1").arg(gribCode,8,16,QLatin1Char('0'));
        }
		// setting (int) : vertical position in meteotable
        QString getSettingName_pos(uint gribCode) {
			return QString("MTableData_pos_%1").arg(gribCode,8,16,QLatin1Char('0'));
        }
        
        void initInterface ();
        void createDataLists ();
        void addItemInDataList (QString name, int code, bool isVisible, int position);
        
		void addData (QString title, uchar grbtype, uchar leveltype, uint level,
		  bool defaultvis, int defaultpos
			);
};


#endif
