from Products.PortalTransforms.interfaces import itransform
from Products.CMFDefault.utils import bodyfinder, scrubHTML

class SafeHTML:
    """Simple transform which uses CMFDefault functions to
    clean potentially bad tags"""

    __implements__ = itransform

    __name__ = "safe_html"
    inputs   = ('text/html',)
    output = "text/x-html-safe"

    def __init__(self, name=None):
        self.config_metadata = {
            'inputs' : ('list', 'Inputs', 'Input(s) MIME type. Change with care.'),
            }
        if name:
            self.__name__ = name

    def name(self):
        return self.__name__

    def __getattr__(self, attr):
        if attr == 'inputs':
            return self.config['inputs']
        if attr == 'output':
            return self.config['output']
        raise AttributeError(attr)

    def convert(self, orig, data, **kwargs):
        safe = scrubHTML(bodyfinder(orig))
        data.setData(safe)
        return data

def register():
    return SafeHTML()
