# unit tests for ZWikiPage

from support import *
import OFS.Image

class ZMITests(unittest.TestCase):
    #def testZMIAddPageForm(self):
    #    ZWikiPage.manage_addZWikiPageForm(client=zc,
    #                                      REQUEST=zc.REQUEST)

    #def testZMIAddWebForm(self):
    #    ZWikiPage.manage_addZWikiPageForm(client=zc,
    #                                      REQUEST=zc.REQUEST)

    #def testZMIAddAndDelete(self):
    #    # sure this is the best way to get at manage_add ?
    #    zc.manage_addProduct['ZWiki'].manage_addZWikiPage('TestPageB', \
    #                                                       title='test page', \
    #                                                       file='blah blah')
    #    assert hasattr(zc,'TestPageB'), 'page not created'
    #    assert zc.TestPageB.text() == 'blah blah', 'wrong text'
    #    assert zc.TestPageB.page_type == 'structuredtext', \
    #           'wrong default page type'
    #    zc.manage_delObjects(['TestPageB'])
    #    assert not hasattr(zc,'TestPageB'), 'page not deleted'

    pass

class ZWikiPageTests(unittest.TestCase):
    def test_canonicalIdFrom(self):
        p = MockZWikiPage()
        self.assertEquals(p.canonicalIdFrom('WikiName'),'WikiName')
        self.assertEquals(p.canonicalIdFrom('ZWikiWikiNames2'),'ZWikiWikiNames2')
        self.assertEquals(p.canonicalIdFrom('a page with !'),'APageWith')
        self.assertEquals(p.canonicalIdFrom('a_page'),'APage')
        self.assertEquals(p.canonicalIdFrom('Test\xc3Page'),'Test_c3Page') # A tilde
        self.assertEquals(p.canonicalIdFrom('\xc3Page'),'X_c3Page')
        self.assertEquals(p.canonicalIdFrom('_c3Page'),'C3Page')

    def test_manage_addZWikiPage(self):
        from Products.ZWiki.ZWikiPage import manage_addZWikiPage
        from OFS.Folder import Folder
        f = Folder()
        manage_addZWikiPage(f,'ZmiTestPage')
        assert hasattr(f,'ZmiTestPage')

    def testEdit(self):
        p = MockZWikiPage(__name__='TestPage')
        p.edit(text='something')
        self.assertEqual(p.read(),'something')
        p.edit(text='')
        self.assertEqual(p.read(),'')

    def testCreateFileOrImage(self):
        #p = MockZWikiPage(__name__='TestPage')
        p = MockZWikiPage().aq_parent.TestPage
        f = p.aq_parent
        file = OFS.Image.Pdata('test file data')

        # our test page/folder initially has no uploads attr.
        self.assert_(not hasattr(p,'uploads'))

        # calling with an unnamed file should do nothing much
        self.assertEqual(p._createFileOrImage(file),(None, None, None))
        
        # ditto for a blank filename
        file.filename = ''
        self.assertEqual(p._createFileOrImage(file),(None, None, None))

        # here, a file object of unknown type should be created
        name = 'testfile'
        file.filename = name
        id, content_type,size = p._createFileOrImage(file)
        self.assertEqual(str(getattr(f,id)),'test file data')
        self.assertEqual(content_type ,'application/octet-stream')
        self.assertEqual(size,14)

        # a text file
        name = 'testfile.txt'
        file.filename = name
        id, content_type,size = p._createFileOrImage(file)
        self.assertEqual(str(f[id]),'test file data')
        self.assertEqual(content_type,'text/plain')

        # an image
        name = 'testfile.gif'
        file.filename = name
        id, content_type,size = p._createFileOrImage(file)
        # evaluating an Image gives its html tag
        self.assertEqual(str(f[id])[-29:] ,
                         '="testfile.gif" border="0" />')
        self.assertEqual(content_type,'image/gif')

    def testEditWithFileUpload(self):
        #p = MockZWikiPage(__name__='TestPage')
        p = MockZWikiPage().aq_parent.TestPage
        f = p.aq_parent

        # add a file to a page
        file = OFS.Image.Pdata('test file data')
        file.filename = 'edittestfile'
        p.REQUEST.file = file
        p.edit(REQUEST=p.REQUEST)

        # the new file should exist
        self.assert_(hasattr(f,'edittestfile'))
        # with the right data
        self.assertEqual(str(f['edittestfile']),'test file data')
        # and a link should have been added to the page
        self.assertEqual(p.read(),'\n\n<a href="edittestfile">edittestfile</a>\n')

        # a file with blank filename should be ignored
        p.REQUEST.file.filename = ''
        old = p.read()
        p.edit(REQUEST=p.REQUEST)
        self.assert_(p.read() == old)

        ## ditto, with an image
        p.edit(text='')
        file = OFS.Image.Pdata('test file data')
        file.filename = 'edittestimage.jpg'
        p.REQUEST.file = file
        p.edit(REQUEST=p.REQUEST)
        self.assert_(hasattr(f,'edittestimage.jpg'))
        self.assertEqual(f['edittestimage.jpg'].content_type,'image/jpeg')
        self.assertEqual(p.read(),'\n\n<img src="edittestimage.jpg">\n')

        # images should not be inlined if dontinline is set
        p.REQUEST.file.filename = 'edittestimage.png'
        p.REQUEST.dontinline = 1
        p.edit(REQUEST=p.REQUEST)
        self.assertEqual(p.read(),
          '\n\n<img src="edittestimage.jpg">\n\n\n<a href="edittestimage.png">edittestimage.png</a>\n')

    def test__handleDeleteMe_redirectToParent(self):
        p = MockZWikiPage()
        p.parents = ['chickens','dogs']
        p._recycle = lambda x: None
        req = MockRequest()
        class MyMockResponse:
            def redirect(self, url):
                self.redirectedto = url
        req.RESPONSE = MyMockResponse()

        # redirect to wiki url if no existing parents
        r = p._handleDeleteMe('DeleteMe',REQUEST=req)
        self.assertEqual(r,1)
        self.assert_(hasattr(req.RESPONSE,'redirectedto'))
        self.assertEqual(req.RESPONSE.redirectedto,
                         p.wiki_url()+'/')
        
        ## redirect to first existing parent
        #p.create(page='Dogs')
        ## was:
        ##r = p._handleDeleteMe('DeleteMe',REQUEST=req)
        ## started breaking when I introduced page titles.
        ## incorrect anyway, should be something like:
        #r = p.aq_parent.Dogs._handleDeleteMe('DeleteMe',REQUEST=req)
        ## but the mock page won't support this
        ## disable the lot for now
        #self.assertEqual(r,1)
        #self.assert_(hasattr(req.RESPONSE,'redirectedto'))
        #self.assertEqual(req.RESPONSE.redirectedto,
        #                 p.wiki_url()+'/'+'Dogs')

    # can't test _recycle easily, because manage_pasteObject needs an app
    #def testDeleteMe(self):
    #    #When we see a first line beginning with "DeleteMe":
    #    #- move to recycle_bin
    #    #- redirect to first parent or default page
    #
    #    p = MockZWikiPage(__name__='TestPage')
    #    f = p.aq_parent
    #    self.assert_(hasattr(f,'TestPage'))
    #    self.assert_(not hasattr(f,'recycle_bin'))
    #
    #    #deleteme's not at the beginning shouldn't do anything
    #    p.edit(text=p.read()+'\nDeleteMe')
    #    self.assertEqual(p.read(),'\nDeleteMe')
    #
    #    #deleteme at the beginning will send it to recycle_bin
    #    p.edit(text='DeleteMe, with comments\n')
    #    self.assert_(not hasattr(f,'TestPage'))
    #    self.assert_(hasattr(f,'recycle_bin'))
    #    self.assertEqual(f.recycle_bin.TestPage.read(),'\nDeleteMe')
    
    # same problem as above
    #def test__recycle(self):
    #    p = MockZWikiPage(__name__='TestPage')
    #    f = p.aq_parent
    #    self.assert_(hasattr(f,'TestPage'))
    #    p._recycle()                     
    #    self.assert_(not hasattr(f,'TestPage'))
    #    self.assert_(hasattr(f,'recycle_bin'))
    #    self.assertEqual(f.recycle_bin.TestPage.read(),'\nDeleteMe')

    #def test_delete(self):
        #p = MockZWikiPage().aq_parent.TestPage
        #f = p.folder()
        #self.assert_(hasattr(f,'TestPage'))
        #p.delete()
        #self.assert_(not hasattr(f,'TestPage'))
        #self.assert_(hasattr(f,'recycle_bin'))
        #self.assert_(hasattr(f.recycle_bin,'TestPage'))

    # failed to make this test work
    #def test_delete_leaves_no_orphans(self):
    #    p = MockZWikiPage(__name__='Page')
    #    f = p.folder()
    #    # create() would give real zwiki pages, build these by hand
    #    child = MockZWikiPage(__name__='Child')
    #    f._setObject('Child',child,set_owner=0)
    #    child.parents = ['Page']
    #    grandchild = MockZWikiPage(__name__='GrandChild')
    #    f._setObject('GrandChild',grandchild,set_owner=0)
    #    grandchild.parents = ['Child']
    #    child._recycle = lambda x: None
    #    child.REQUEST.cookies['zwiki_username'] = 'someusername'
    #    child.delete(REQUEST=child.REQUEST)
    #    self.assertEquals(grandchild.parents,['Page'])
        
    def testEditLastEditorStamping(self):
        # Username stamping
        p = MockZWikiPage(__name__='TestPage')
        f = p.aq_parent
        p.last_editor = '-'

        # if no username available, IP address should be recorded
        p.REQUEST.set('REMOTE_ADDR', '1.2.3.4')
        p.append(text='.',REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'1.2.3.4')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

        # use the zwiki_username cookie if available
        p.REQUEST.cookies['zwiki_username'] = 'cookiename'
        p.append(text='.',REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'cookiename')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

        # if we are authenticated, use that by preference
        p.REQUEST.set('AUTHENTICATED_USER', MockUser('authusername'))
        p.append(text='.',REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'authusername')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

        # don't record editor if nothing is actually changed
        p.REQUEST.set('AUTHENTICATED_USER', MockUser('differentusername'))
        p.REQUEST.set('REMOTE_ADDR', '5.6.7.8')
        p.edit(text=p.read(),REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'authusername')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

    def test_create(self):
        #p = MockZWikiPage()
        p = MockZWikiPage().aq_parent.TestPage
        f = p.aq_parent
        
        # create a blank page
        p.create('TestPage1',text='')
        self.assert_(hasattr(f,'TestPage1'))
        self.assertEqual(f.TestPage1.text(),'')
        
        # create a classicwiki page with some text
        p.create('TestPage2',text='test page data',type='classicwiki')
        self.assert_(hasattr(f,'TestPage1'))
        self.assertEqual(f.TestPage2.read(),'test page data')
        self.assertEqual(f.TestPage2.page_type,'classicwiki')

# having trouble making MZP support this
# _handleFileUpload -> _checkPermission(,MZP.folder()) loops
# because page.aq_parent.aq_parent == page
# even if you set it to None, somewhere it comes back
#    def testCreateWithFileUpload(self):
#        p = MockZWikiPage().aq_parent.TestPage
#        f = p.folder()
#        f.aq_parent = None
#        
#        # upload a file while creating a page
#        # this capability broke - fix if ever needed
#        # and most of this is tested above I think
#        file = OFS.Image.Pdata('test file data')
#        file.filename = 'test_file'
#        p.REQUEST.file = file
#        p.create('TestPage3',text='test page data',REQUEST=p.REQUEST)
#        # the new file should exist
#        self.assert_(hasattr(f,'test_file'))
#        # with the right data
#        self.assertEqual(str(f['test_file']),'test file data')
#        # and a link should have been added to the new wiki page
#        self.assertEqual(f.TestPage3.read(),
#          'test page data\n\n<a href="test_file">test_file</a>\n')
#
#        # ditto with an image
#        file.filename = 'test_image.gif'
#        p.REQUEST.file = file
#        f.TestPage.create('TestPage4',text='test page data',REQUEST=p.REQUEST)
#        self.assert_(hasattr(f,'test_image.gif'))
#        self.assertEqual(f['test_image.gif'].content_type,'image/gif')
#        self.assertEqual(f.TestPage4.read(),
#                         'test page data\n\n<img src="test_image.gif">\n')
#
#        # images should not be inlined if dontinline is set
#        file.filename = 'test_image.JPG'
#        p.REQUEST.dontinline = 1
#        f.TestPage.create('TestPage5',text='',REQUEST=p.REQUEST)
#        self.assertEqual(f.TestPage5.read(),
#                         '\n\n<a href="test_image.JPG">test_image.JPG</a>\n')

    def testIssueNo0112StxDoubleHtmlTag(self):
        p = MockZWikiPage()
        p.edit(type='structuredtext')
        text = p()
        self.assertEquals(
            len(re.findall(r'(?i)<html',text)),
            0)
        self.assertEquals(
            len(re.findall(r'(?i)<body',text)),
            0)

    def test_comment(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.edit(text='test')
        p.comment(text='comment',username='me',time='now')
        self.assertEquals(p.read(),'test\n\ncomment')
        p.comment(text='comment',username='me',time='now',use_heading=1)
        self.assertEquals(p.read(),
                          'test\n\ncomment\n\n<b>...</b> --me, now<br>\ncomment')
        #NB the \n's are \012's with zope < 2.4
        
    def testCommentFormatting(self):
        USER = "me"
        TIME = "now"
        COMMENT = """\
short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb

quoted lines

> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc
> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc

long quoted lines

> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
"""
        SHOULDWRITE = """\


<b>...</b> --me, now<br>
short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb

quoted lines

<br>><i> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc</i>
<br>><i> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc</i>

long quoted lines

<br>><i> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd</i>
<br>><i> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd</i>
"""
        SHOULDDIFF = """\


<b>...</b> --me, now<br>
short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb

quoted lines

<br>><i> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc</i>
<br>><i> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc</i>

long quoted lines

<br>><i> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd</i>
<br>><i> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd</i>

"""
        SHOULDMAILOUT = """\
short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb

quoted lines

> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc
> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc

long quoted lines

> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd
dd
> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd
dd
"""
        COMMENT2 = "bah\n"
        SHOULDWRITE2 = "\n\nbah\n"
        SHOULDDIFF2 = "\n\nbah\n\n"
        SHOULDMAILOUT2 = "bah\n"

        from Products.ZWiki.Diff import DiffSupport
        p = MockZWikiPage().aq_parent.TestPage # simulate acquisition

        # test formatting at each stage, using a comment heading
        oldtext = p.read()
        p.comment(text=COMMENT,username=USER,time=TIME,use_heading=1)
        self.assertEqual(p.read(), SHOULDWRITE)
        diff = DiffSupport().textDiff(a=oldtext,b=p.read(),verbose=0)
        self.assertEqual(diff,SHOULDDIFF)
        self.assertEqual(p.formatMailout(diff), SHOULDMAILOUT)

        # without heading
        p.edit(text='')
        oldtext = p.read()
        p.comment(text=COMMENT2,username=USER,time=TIME,use_heading=0)
        self.assertEqual(p.read(), SHOULDWRITE2)
        diff = DiffSupport().textDiff(a=oldtext,b=p.read(),verbose=0)
        self.assertEqual(diff,SHOULDDIFF2)
        self.assertEqual(p.formatMailout(diff), SHOULDMAILOUT2)

        # with edits mailout policy (so edit does the mailout, not comment)
        p.folder().mailout_policy = 'edits'
        p.edit(text='')
        oldtext = p.read()
        p.comment(text=COMMENT,username=USER,time=TIME,use_heading=1)
        self.assertEqual(p.read(), SHOULDWRITE)
        diff = DiffSupport().textDiff(a=oldtext,b=p.read(),verbose=0)
        self.assertEqual(diff,SHOULDDIFF)
        self.assertEqual(p.formatMailout(diff), SHOULDMAILOUT)

    def test__setText(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.edit(text='<html blah>\n<body blah>\ntest\n</body>\n</html>')
        self.assertEqual(p.read(),'\ntest\n')

    def test__setLastEditor(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.REQUEST.set('REMOTE_ADDR', '1.2.3.4')
        p.REQUEST.set('AUTHENTICATED_USER', MockUser('user'))
        p._setLastEditor(REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'user')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

    def test__setCreator(self):
        p = MockZWikiPage().aq_parent.TestPage
        r = MockRequest()
        u = MockUser('test user')
        r.set('AUTHENTICATED_USER',u)
        r.set('REMOTE_ADDR','4.3.2.1')
        p._setCreator()
        self.assert_(p.creation_time)
        self.assertEqual(p.creator_ip,'')
        self.assertEqual(p.creator,'')
        p._setCreator(r)
        self.assertEqual(p.creator_ip,'4.3.2.1')
        self.assertEqual(p.creator,'test user')
        
    def test_text(self):
        p = MockZWikiPage().aq_parent.TestPage
        # ensure we don't lose first lines to DTML's decapitate()
        p._setText(r'first: line\n\nsecond line\n')
        self.assertEqual(p.text(),'first: line\\n\\nsecond line\\n')
        # ensure none of these reveal the antidecapkludge
        p.edit(type='htmldtml')
        p._setText('test text')
        self.assertEqual(p.text(),'test text')
        from Products.ZWiki.ZWikiPage import ZOPEVERSION
        if ZOPEVERSION >= (2,4):
            self.assertEqual(p.read(),'test text')
            self.assertEqual(p.__str__(),'test text')
        else:
            # what ?
            self.assertEqual(p.read(),'test text')
            self.assertEqual(p.__str__(),'test text')

    def test_asAgeString(self):
        p = MockZWikiPage().aq_parent.TestPage
        self.assertEqual(p.asAgeString(p.last_edit_time),'some time')

    # MZP doesn't support manage_renameObject
    #def test_rename_leaves_no_orphans(self):
    #    p = MockZWikiPage('parent page')
    #    c = p.create('child page')
    #    p.rename('new parent name')
    #    self.assertEquals(['new parent name'],c.parents)

    #def test_upgrade_ids(self):
    #    p = MockZWikiPage(__name__='SomeId').aq_parent.SomeId
    #    p.title = 'something elSe!'
    #    p.upgrade()
    #    self.assertEqual(p.id(),'SomethingElse')

    def test_pageIdsStartingWith(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.create('TestPage2')
        self.assertEqual(p.pageIdsStartingWith('Test'),
                         ['TestPage','TestPage2'])

    def test_pageNamesStartingWith(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.title = 'Test Page'
        p.create('Test Page 2')
        self.assertEqual(p.pageNamesStartingWith('Test'),
                         ['Test Page','Test Page 2'])

    def test_firstPageIdStartingWith(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.create('TestPage2')
        self.assertEqual(p.firstPageIdStartingWith('Test'),'TestPage')

    def test_firstPageNameStartingWith(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.title = 'Test Page'
        p.create('Test Page 2')
        self.assertEqual(p.firstPageNameStartingWith('Test'),'Test Page')

    def test_pageWithId(self):
        p = MockZWikiPage().aq_parent.TestPage
        self.assertEqual(p.pageWithId('nosuchid'),None)
        self.assertEqual(p.pageWithId('TestPage'),p)
        self.assertEqual(p.pageWithId('testpage'),None)
        self.assertEqual(p.pageWithId('testpage',ignore_case=1),p)

    def test_pageWithName(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.title = 'Test page'
        self.assertEqual(p.pageWithName(p.title),p)

    def test_pageWithFuzzyName(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.title = 'Test page'
        self.assertEqual(p.pageWithFuzzyName('Test page'),p)
        self.assertEqual(p.pageWithFuzzyName(' Test  page\t'),p)
        self.assertEqual(p.pageWithFuzzyName('TestPage'),p)
        self.assertEqual(p.pageWithFuzzyName('TEST Page'),p)
        self.assertEqual(p.pageWithFuzzyName('Testpage'),p)
        self.assertEqual(p.pageWithFuzzyName('test'),None)
        self.assertEqual(p.pageWithFuzzyName('test',allow_partial=1),p)

    def test_backlinksFor(self):
        p = MockZWikiPage().aq_parent.TestPage
        p.title = 'Test Page'
        p.create('PageTwo',text='[Test Page]')
        p.create('PageThree',text='TestPage')
        self.assertEqual(len(p.backlinksFor('Test Page')),2)

def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(ZMITests))
    suite.addTest(unittest.makeSuite(ZWikiPageTests))
    return suite

def main():
    unittest.TextTestRunner().run(test_suite())

if __name__ == '__main__':
    main()
