# ZShellCLI - (c) 2001 Andy McKay
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# This software is now part of Jerome Alet's ZShell

# Thanks Amos and Chris at DC
# http://www.zope.org/Members/Amos/XML-RPC

#
# $Id: xmlrpclibBasicAuth.py,v 1.3 2001/08/30 13:09:11 jerome Exp $
#
# $Log: xmlrpclibBasicAuth.py,v $
# Revision 1.3  2001/08/30 13:09:11  jerome
# CVS Id and Log markers added
#
#

# path to xmlrpclib, works fine in Zope but when running from the command line
# seems to fail. Annoying.
# import sys
# sys.path.insert(0, r'd:\XMLTest1\lib\python')

import string, xmlrpclib, httplib
from base64 import encodestring

def Server(url, username, password):
    t = BasicAuthTransport(username, password)
    return xmlrpclib.Server(url, t)

class BasicAuthTransport(xmlrpclib.Transport):
    def __init__(self, username=None, password=None):
	self.username = username
	self.password = password
	self.verbose = None

    def request(self, host, handler, request_body):
	# issue XML-RPC request
	h = httplib.HTTP(host)
	h.putrequest("POST", handler)

	# required by HTTP/1.1
	h.putheader("Host", host)

	# required by XML-RPC
	h.putheader("User-Agent", self.user_agent)
	h.putheader("Content-Type", "text/xml")
	h.putheader("Content-Length", str(len(request_body)))

	# basic auth
	if self.username is not None and self.password is not None:
	    h.putheader("AUTHORIZATION", "Basic %s" % string.replace(
		    encodestring("%s:%s" % (self.username, self.password)),
		    "\012", ""))
	h.endheaders()

	if request_body: h.send(request_body)
	errcode, errmsg, headers = h.getreply()

	if errcode != 200:
	    raise xmlrpclib.ProtocolError(host + handler, errcode, errmsg, headers)

	return self.parse_response(h.getfile())

if __name__=='__main__':
    pass
