###################################################################################################
# _ftpmanager.py
#
# $Id: _ftpmanager.py,v 1.1 2003/08/31 13:29:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.1 $
#
# Implementation of class _ftpmanager.FtpManager (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTMLFile
import urllib
import ftplib
import time
import os
import stat
# Product Imports.
import _fileutil
import _globals


# ---------------------------------------------------------------------------------------------
#  _ftpmanager.recurse_Local:
# ---------------------------------------------------------------------------------------------
def recurse_Local(ftp, remoteFolder='', localFolder='', sPath=''):
  #++ print '[recurse_Local]: Path="%s"'%(sPath)
  for sFile in os.listdir(localFolder+sPath+'/'):
    fStat = os.stat(localFolder+sPath+'/'+sFile)
    fSize = fStat[stat.ST_SIZE]
    fMode = fStat[stat.ST_MODE]
    if stat.S_ISDIR(fMode):
      # Change to new directory (if it does not exist it will be created).
      ftpCwd(ftp,remoteFolder+sPath,sFile)
      # Recurse.
      recurse_Local(ftp,remoteFolder,localFolder,sPath+'/'+sFile)
      # Change back to current directory.
      ftp.cwd(remoteFolder+sPath+'/')
    else:
      # Delete existing file.
      try:
        ftp.delete(sFile)
      except: pass
      # Create new file.
      try:
        file = open(localFolder+sPath+'/'+sFile,'rb')
        ftp.storbinary('STOR %s'%sFile,file,fSize)
        file.close()
      except: pass


# ---------------------------------------------------------------------------------------------
#  _ftpmanager.ftpCwd:
#	
#  Change work directory on ftp-host.
# ---------------------------------------------------------------------------------------------
def ftpCwd(ftp, path, dir):
  #++ print '[ftpCwd]: %s/%s'%(path,dir)
  # Change to new directory.
  try:
    ftp.cwd(path + '/' + dir)
  # Create new directory.
  except:
    try:
      ftp.mkd(dir)
    except:
      pass
    ftp.cwd(path + '/' + dir)


# ---------------------------------------------------------------------------------------------
#  _ftpmanager.ftpToProvider:
# ---------------------------------------------------------------------------------------------
def ftpToProvider(self, lang, manage_lang, REQUEST, RESPONSE):
    message = ''
    
    # Profile time.
    tStart = time.time()
    
    # Create temporary local-folder.
    s_tmp_folder = self.__prepare_temp_export_folder__(from_content=1,from_zms=1,from_common=1,REQUEST=REQUEST)
    # Download HTML-pages to temporary local-folder.
    self.recurse_downloadHtmlPages(self,s_tmp_folder,REQUEST)
    
    # Connect to FTP-server.
    # ----------------------
    dctFtp = self.getFtp(REQUEST)
    try:
      ftp = ftplib.FTP(dctFtp['site'])
      ftp.set_debuglevel(1) # 0=no, 1=moderate, 2=maximum debugging output
      ftp.login(dctFtp['userid'],dctFtp['password'])
      ftpCwd(ftp,'',dctFtp['path'])
      recurse_Local(ftp,dctFtp['path'],s_tmp_folder)
      message += ftp.getwelcome()+'<br>'
      ftp.quit()
      
    except:
      message += _globals.writeException(self,"[_ftpmanager.ftpToProvider]:")+'<br>'
    
    # Remove temporary local-folder.
    _fileutil.remove(s_tmp_folder,deep=1)
    
    # Return with message.
    message += self.getLangStr('MSG_EXPORTED',manage_lang)%('%s <b>%s</b> in %d sec.'%(self.display_type(REQUEST),dctFtp['site']+dctFtp['path'],(time.time()-tStart)))
    return message


###################################################################################################
###################################################################################################
###
###   class FtpManager
###
###################################################################################################
###################################################################################################
class FtpManager: 

    # Management Interface.
    # ---------------------
    manage_importexportFtp = HTMLFile('dtml/zmscontainerobject/manage_importexportftp', globals()) 


    # ---------------------------------------------------------------------------------------------
    #  FtpManager.getFtp: 
    #
    #  Get parameters of FTP access to provider.
    # ---------------------------------------------------------------------------------------------
    def getFtp(self, REQUEST): 
      if getattr(self,'attr_provider_ftp_site','') and \
      	 getattr(self,'attr_provider_ftp_userid','') and \
      	 getattr(self,'attr_provider_ftp_password',''):
        rtn = {}
        rtn['site'] = getattr(self,'attr_provider_ftp_site','')
        rtn['path'] = getattr(self,'attr_provider_ftp_path','')
        rtn['userid'] = getattr(self,'attr_provider_ftp_userid','')
        rtn['password'] = getattr(self,'attr_provider_ftp_password','')
        return rtn
      return None         

    ###############################################################################################
    # FtpManager.manage_customizeFtp: 
    #
    # Change parameters of FTP access to provider.
    ###############################################################################################
    def manage_customizeFtp(self, btn, lang, manage_lang, REQUEST, RESPONSE):
      """ FtpManager.manage_customizeFtp """
      
      message = ''
      
      # Change.
      # -------
      self.attr_provider_ftp_site = REQUEST['site']
      self.attr_provider_ftp_path = REQUEST['path']
      self.attr_provider_ftp_userid = REQUEST['userid']
      self.attr_provider_ftp_password = REQUEST['password']
      message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Ping.
      # -----
      if btn == self.getLangStr('BTN_PING',manage_lang):
        try:
          # Profile time.
          tStart = time.time()
          ftp = ftplib.FTP(self.attr_provider_ftp_site)
          ftp.set_debuglevel(1) # moderate output
          ftp.login(self.attr_provider_ftp_userid,self.attr_provider_ftp_password)
          message = '%s%s<br>'%(message,ftp.getwelcome())
          ftp.quit()
          message = 'Ping in %d sec.'%(time.time()-tStart)
        except:
          message = _globals.writeException(self,"[manage_customizeFtp]:")
      
      # Export.
      # -------
      if btn == self.getLangStr('BTN_EXPORT',manage_lang):
        message = ftpToProvider(self,lang,manage_lang,REQUEST,RESPONSE)

      # Return with message.
      return REQUEST.RESPONSE.redirect('manage_importexportFtp?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,urllib.quote(message)))

###################################################################################################
