# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz>
__version__ = '$Revision: 1.1 $'[11:-2]

from Products.CMFCore.CMFCorePermissions import \
     View, ModifyPortalContent, AccessContentsInformation, \
     ReviewPortalContent, RequestReview

from Products.CMFCore.WorkflowTool import addWorkflowFactory
from Products.DCWorkflow.DCWorkflow import DCWorkflowDefinition
from Products.DCWorkflow.Transitions import TRIGGER_AUTOMATIC, TRIGGER_WORKFLOW_METHOD
from Products.PythonScripts.PythonScript import manage_addPythonScript

from PortalTransportPermissions import *

p_access = AccessContentsInformation
p_modify = ModifyPortalContent
p_view = View
p_review = ReviewPortalContent
p_request = RequestReview

r_anon = 'Anonymous'
r_manager = 'Manager'
r_member = 'Member'
r_owner = 'Owner'

def setupSubscriptionWorkflow(wf):
    wf.setProperties(title='Subscription Info Workflow [PortalTransport]')

    for s in ('initial', 'active', 'activation', 'deactive', 'deactivation'):
        wf.states.addState(s)
    for t in ('auto_active', 'auto_activation', 'activate', 'activation',
              'deactivation', 'deactivate',
              'wm_activate', 'wm_activation',
              'wm_deactivate', 'wm_deactivation',
              'wm_rollback_deactivation'):
        wf.transitions.addTransition(t)
    for v in ('action', 'actor', 'comments', 'review_history', 'time'):
        wf.variables.addVariable(v)

    manage_addPythonScript(wf.scripts, 'stateChanged')
    scr = getattr(wf.scripts, 'stateChanged')
    scr.write(
"""##parameters=sci
sci.object.notifyStateChanged(sci)
""")

    wf.states.setInitialState('initial')

    ############## workflow states ################
    sdef = wf.states['initial']
    sdef.setProperties(
        title='Initial state',
        transitions=('auto_active', 'auto_activation',))

    sdef = wf.states['active']
    sdef.setProperties(
        title='Active',
        transitions=('deactivation','wm_deactivate', 'wm_deactivation'))

    sdef = wf.states['activation']
    sdef.setProperties(
        title='Activation process',
        transitions=('activate','wm_deactivate','wm_activate'))

    sdef = wf.states['deactive']
    sdef.setProperties(
        title='',
        transitions=('activation',))

    sdef = wf.states['deactivation']
    sdef.setProperties(
        title='Deactivation process',
        transitions=('deactivate','wm_deactivate'))

    ############# transitions ##############
    tdef = wf.transitions['auto_active']
    tdef.setProperties(
        title='',
        new_state_id='active',
        actbox_name='Auto activate',
        trigger_type=TRIGGER_AUTOMATIC,
        after_script_name='stateChanged',
        props={ 'guard_expr':'here/isAutoActivate'})

    tdef = wf.transitions['auto_activation']
    tdef.setProperties(
        title='',
        new_state_id='activation',
        trigger_type=TRIGGER_AUTOMATIC,
        after_script_name='stateChanged',
        props={ 'guard_expr':'not:here/isAutoActivate'})

    tdef = wf.transitions['activate']
    tdef.setProperties(
        title='Activate subscription',
        new_state_id='active',
        actbox_name='Activate',
        after_script_name='stateChanged',
        props={'guard_permissions': p_review})

    tdef = wf.transitions['activation']
    tdef.setProperties(
        title='Activation process',
        new_state_id='activation',
        actbox_name='Activation',
        after_script_name='stateChanged',
        props={'guard_permissions':p_request})

    tdef = wf.transitions['deactivate']
    tdef.setProperties(
        title='Remove subscription',
        new_state_id='deactive',
        actbox_name='Deactivate',
        after_script_name='stateChanged',
        props={'guard_permissions':p_review})

    tdef = wf.transitions['deactivation']
    tdef.setProperties(
        title='Remove subscription process',
        new_state_id='deactivation',
        actbox_name='Deactivation',
        after_script_name='stateChanged',
        props={'guard_roles': r_owner})

    tdef = wf.transitions['wm_activate']
    tdef.setProperties(
        title='Activate',
        new_state_id='active',
        actbox_name='Activate',
        trigger_type=TRIGGER_WORKFLOW_METHOD,)

    tdef = wf.transitions['wm_activation']
    tdef.setProperties(
        title='Activation',
        new_state_id='activation',
        actbox_name='Activation',
        trigger_type=TRIGGER_WORKFLOW_METHOD,)

    tdef = wf.transitions['wm_deactivate']
    tdef.setProperties(
        title='Deactivate',
        new_state_id='deactive',
        actbox_name='Deactivate',
        trigger_type=TRIGGER_WORKFLOW_METHOD,)

    tdef = wf.transitions['wm_deactivation']
    tdef.setProperties(
        title='Deactivation',
        new_state_id='deactivation',
        actbox_name='Deactivation',
        trigger_type=TRIGGER_WORKFLOW_METHOD,)
        
    tdef = wf.transitions['wm_rollback_deactivation']
    tdef.setProperties(
        title='Back to active state',
        new_state_id='active',
        actbox_name='Rollback Deactivation',
        trigger_type=TRIGGER_WORKFLOW_METHOD,)

    wf.variables.setStateVar('review_state')

    ############## variables #############
    vdef = wf.variables['action']
    vdef.setProperties(description='The last transition',
                       default_expr='transition/getId|nothing',
                       for_status=1, update_always=1)

    vdef = wf.variables['actor']
    vdef.setProperties(description='The ID of the user who performed '
                       'the last transition',
                       default_expr='user/getId',
                       for_status=1, update_always=1)

    vdef = wf.variables['comments']
    vdef.setProperties(description='Comments about the last transition',
                       default_expr="python:state_change.kwargs.get('comment', '')",
                       for_status=1, update_always=1)

    vdef = wf.variables['review_history']
    vdef.setProperties(description='Provides access to workflow history',
                       default_expr="state_change/getHistory",
                       props={'guard_permissions':
                              p_request + ';' + p_review})

    vdef = wf.variables['time']
    vdef.setProperties(description='Time of the last transition',
                       default_expr="state_change/getDateTime",
                       for_status=1, update_always=1)


def createSubscriptionWorkflow(id):
    ob=DCWorkflowDefinition(id)
    setupSubscriptionWorkflow(ob)
    return ob

si_workflow = 'pt_si_workflow (Subscription Info Workflow [PortalTransport])'
si_workflow_id = 'pt_si_workflow'

addWorkflowFactory(createSubscriptionWorkflow, si_workflow_id,
                   title='Subscription Info Workflow [PortalTransport]')
