# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz> 
__version__ = '$Revision: 1.8 $'[11:-2]

import re, traceback
from Globals import InitializeClass
from DateTime import DateTime
from Acquisition import aq_base, aq_inner, aq_parent
from AccessControl import ClassSecurityInfo
from OFS.PropertyManager import PropertyManager
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.WorkflowCore import WorkflowAction, ObjectDeleted
from Products.CMFCore.CMFCorePermissions import View
from Products.Archetypes.public import *
from Products.Archetypes.config import TOOL_NAME
from Products.Archetypes.interfaces.referenceable import IReferenceable
from email.Utils import formataddr

try:
    from Products.Archetypes.config import UUID_ATTR
except:
    UUID_ATTR = '_uid'

from config import *
from interfaces.subscribeable import *

state_mappings = {
    'activation': 'subscription_activation',
    'deactivation': 'subscription_deactivation',
    'active': 'subscribed_message',
    'deactive': 'unsubscribed_message',
    }


class BaseSubscriptionInfo(BaseContent, PropertyManager):
    """ class for manage single subscription """
    security = ClassSecurityInfo()

    global_allow = 0

    _properties = (
        {'id': 'member_id', 'type': 'string', 'mode': 'w'},
        {'id': 'content_uid', 'type': 'string', 'mode': 'w'},
        {'id': 'hint', 'type': 'string', 'mode': 'w'},
        )

    def __init__(self, oid, uid, content, hint='', **kw):
        BaseContent.__init__(self, oid, **kw)
	setattr(self, UUID_ATTR, uid)

        if not IReferenceable.isImplementedBy(content):
            raise ValueError, "Content dousn't support IReferenceable interface"
        if not IBaseSubscribeable.isImplementedBy(content):
            raise ValueError, "Content dousn't support IBaseSubscribeable interface"

        self.content_uid = content.UID()
        self.hint = hint

    security.declareProtected(ModifyPortalContent, 'indexObject')
    def indexObject(self):
        """ """
        aq_parent(self).catalog_object(self, '/'.join(self.getPhysicalPath()))

    security.declareProtected(ModifyPortalContent, 'unindexObject')
    def unindexObject(self):
        """ """
        aq_parent(self).uncatalog_object('/'.join(self.getPhysicalPath()))

    security.declareProtected(ModifyPortalContent, 'reindexObject')
    def reindexObject(self, idxs=[]):
        """ """
        if idxs == []:
            if hasattr(aq_base(self), 'notifyModified'):
                self.notifyModified()
        aq_parent(self).catalog_object(self, '/'.join(self.getPhysicalPath()), idxs=idxs)

    security.declareProtected(View, 'review_state')
    def review_state(self):
        """ """
        return getToolByName(self, 'portal_workflow').getInfoFor(self, 'review_state', '')

    security.declareProtected(ModifyPortalContent, 'unindexObject')
    def getSubscribedContent(self):
        """ """
        tool = getToolByName(self, TOOL_NAME)
        return tool.lookupObject(self.content_uid)

    security.declarePrivate('sendNotification')
    def sendNotification(self, content, template):
        """ send unsubscriotion notification to author """
        portal = getToolByName(self, 'portal_url').getPortalObject()
        pmt = portal.portal_mailtemplates
        mspool = portal.portal_mailspool

        #try:
        #    if not content.isSendSubscriptionNotifications():
        #        return
        #except:
        #    pass

        uid = getattr(self, UUID_ATTR)
        email = self.getEmail()
        
        info = self._getInfo(content)
        info.update({'content': content,
                     'content_url': content.absolute_url(),
                     'content_title': content.Title(),
                     'content_email': email,
		     'subscribe_url': '%s/pt_subscription_form'%self.absolute_url(),
                     'unsubscribe_url': '%s/pt_unsubscribe_form'%self.absolute_url(),
		     'confirm_url': '%s/confirm'%self.absolute_url(),
                     })
        headers = {'To': email}

        try:
            from_email = content.getEmailAddress()
            if from_email:
                headers['From'] = from_email
            else:
                headers['From'] = self.email_from_address
        except:
            headers['From'] = self.email_from_address

        msg = pmt.createMessage(PROJECTNAME, template, info, headers)
        mspool.sendmail(headers['From'], headers['To'], msg)

    def notifyStateChanged(self, sci):
        """ """
        m = getattr(self, 'wm_%s'%sci.transition.getId(), None)
        if (m is not None) and callable(m):
            m()
        else:
            new_state = sci.new_state.getId()

            if state_mappings.has_key(new_state):
                content = self.getSubscribedContent()
                if content is not None:
                    try:
                        self.sendNotification(content, state_mappings[new_state])
                    except:
                        traceback.print_exc()


    #########################################################
    ##     Workflow methods
    #########################################################

    security.declareProtected(ManagePortal, 'wa_activate')
    def wm_activate(self, status=''):
        """ workflow method to activate subscription """
        content = self.getSubscribedContent()
        if content is not None:
            self.sendNotification(content, 'subscribed_message')

    security.declareProtected(ManagePortal, 'wa_activation')
    def wm_activation(self, status=''):
        """ """
        content = self.getSubscribedContent()
        if content is not None:
            self.sendNotification(content, 'subscription_activation')

    security.declareProtected(ManagePortal, 'wa_deactivate')
    def wm_deactivate(self, status=''):
        """ workflow method to deactivate subscription """
        content = self.getSubscribedContent()
        if content is not None:
            self.sendNotification(content, 'unsubscribed_message')

        aq_parent(aq_inner(self))._delObject(self.getId())
        raise ObjectDeleted, None

    security.declareProtected(ManagePortal, 'wa_deactivation')
    def wm_deactivation(self, status=''):
        """ workflow method to activate subscription """
        content = self.getSubscribedContent()
        if content is not None:
            self.sendNotification(content, 'subscription_deactivation')

    security.declareProtected(ManagePortal, 'wm_rollback_deactivation')
    def wm_rollback_deactivation(self):
        """ """
	pass

    wm_activate = WorkflowAction(wm_activate)
    wm_deactivate = WorkflowAction(wm_deactivate)
    wm_deactivation = WorkflowAction(wm_deactivation)
    wm_rollback_deactivation = WorkflowAction(wm_rollback_deactivation)


InitializeClass(BaseSubscriptionInfo)
