# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.biz>
__version__ = '$Revision: 1.23 $'[11:-2]

import traceback
from Acquisition import aq_base, aq_parent, aq_inner
from AccessControl import ClassSecurityInfo
from OFS.Image import File
from Products.Archetypes.public import *
from Products.PageTemplates.ZopePageTemplate import ZopePageTemplate
from Products.PageTemplates.Expressions import getEngine, SecureModuleImporter
from Products.PageTemplates.GlobalTranslationService import \
     getGlobalTranslationService
from Products.CMFCore.CMFCorePermissions import View, ModifyPortalContent
from Products.CMFCore.Expression import Expression
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.FSObject import FSObject
from Products.Archetypes.public import *

from email import Utils, Encoders
from email.MIMEText import MIMEText
from email.MIMEMultipart import MIMEMultipart
from email.MIMENonMultipart import MIMENonMultipart
from email.Header import make_header

try:
    import stripogram
except:
    from Products import stripogram

schema = BaseSchema + Schema((
    StringField('before_script', required=0, default='',
                vocabulary = '_get_scripts_list',
                write_permission=ModifyPortalContent,
                widget=SelectionWidget(label='Before script',
                                       description='This script would be called before template rendering.',
                                       label_msgid='label_before_script',
                                       description_msgid='help_before_script',
                                       format='select',
                                       i18n_domain='PortalTransport')),
    BooleanField('strip_html', required=0, default=0,
                 write_permission=ModifyPortalContent,
                 widget=BooleanWidget(label='Strip html',
                                      label_msgid='label_striphtml',
                                      description_msgid='help_striphtml',
                                      i18n_domain='PortalTransport')),
    StringField( 'mail_subject', required=1,
                 mutator = '_setMailSubject',
                 write_permission=ModifyPortalContent,
                 widget=StringWidget(label='Subject',
                                     label_msgid='label_subject',
                                     description_msgid='help_subject',
                                     size=80,
                                     i18n_domain='PortalTransport')),
    StringField( 'mail_body', required=1,
                 mutator = '_setMailBody',
                 write_permission=ModifyPortalContent,
                 widget=TextAreaWidget(label='Body', rows=10,
                                       label_msgid='label_body',
                                       description_msgid='help_body',
                                       i18n_domain='PortalTransport')),
    StringField( 'description', default='',
                 write_permission=ModifyPortalContent,
                 widget=TextAreaWidget(label_msgid='label_description',
                                       description_msgid='help_description',
                                       i18n_domain='plone')),
    ))


class PT_MailTemplate(BaseContent):
    """ """
    security = ClassSecurityInfo()
    archetype_name = 'Mail Template'

    schema = schema
    global_allow = 0

    actions = (
            { 'id': 'view',
              'name': 'View',
              'action': 'string:$object_url/mailtemplate_view',
              'permissions': (View,)
              },
            )

    def __init__(self, oid, **kwargs):
        BaseContent.__init__(self, oid, **kwargs)
        self.pt = ZopePageTemplate('pt')
        self.subject_expr = None

    def _get_scripts_list(self):
        res = [('', '-- None --'),]
        for ob in aq_parent(aq_inner(self)).scripts.objectValues('Script (Python)'):
            res.append((ob.getId(), ob.title_or_id()))
        return DisplayList((res))

    def _getMessage(self, info, headers={}, charset=None, text_format='plain'):
        """ render a mail template """

        category = aq_parent(aq_inner(self))
        portal = aq_parent(aq_inner(aq_parent(category)))

        info['portal'] = portal
        info['portal_url'] = portal.absolute_url()
        info['portal_title'] = portal.Title()

        if charset is None:
            charset = portal.portal_properties.site_properties.default_charset

        mail_body = self.pt.pt_render(extra_context={'options': info})
        
        if self.strip_html:
            mail_body = stripogram.html2text(mail_body)

        message = MIMEText(mail_body, text_format, charset)

        subject_expr = self.subject_expr
        if not headers.has_key('Subject') and (subject_expr is not None):
            root = self.getPhysicalRoot()
            c = {
                'root': root,
                'here': self,
                'portal': portal,
                'nothing': None,
                'request': getattr(root, 'REQUEST', None),
                'modules': SecureModuleImporter,
                'options': info,
                }
            context = getEngine().getContext(c)
            message['Subject'] = subject_expr(context)

        for key, val in headers.items():
            message[key] = val

        return message

    def _setMailBody(self, value, **kwargs):
        self.getField('mail_body').set(self, value, **kwargs)
        self.pt.write(self.getField('mail_body').get(self))

    def _setMailSubject(self, value, **kwargs):
        self.getField('mail_subject').set(self, value, **kwargs)

        text = self.getField('mail_subject').get(self)
        
        if text: # Fix for zope version < 2.7
            self.subject_expr = Expression(text.strip())

    def _getMultipartMessage(self, info, headers, charset, text_format,
                             messages, files, multipart_format='mixed'):
        message = MIMEMultipart(multipart_format)

        # attache messages
        for msg in (self._getMessage(info, {}, charset, text_format),) + tuple(messages):
            message.attach(msg)

        # insert headers
        for key, val in headers.items():
            message[key] = val

        # add Subject header
        portal = aq_parent(aq_inner(aq_parent(aq_parent(aq_inner(self)))))

        info['portal'] = portal
        info['portal_url'] = portal.absolute_url()
        info['portal_title'] = portal.Title()

        subject_expr = self.subject_expr
        if not headers.has_key('Subject') and (subject_expr is not None):
            root = self.getPhysicalRoot()
            c = {
                'root': root,
                'here': self,
                'portal': portal,
                'nothing': None,
                'request': getattr(root, 'REQUEST', None),
                'modules': SecureModuleImporter,
                'options': info,
                }
            context = getEngine().getContext(c)
            message['Subject'] = subject_expr(context)

        # attache files
        for file_data, content_type, filename in files:
            maintype, subtype = content_type.split('/')

            msg = MIMENonMultipart(maintype, subtype)

            # hack for allow python scripts add images and files to message
            try:
                if isinstance(file_data, File):
                    file_data = str(file_data.data)
                elif isinstance(file_data, FSObject):
                    file_data = str(file_data._readFile(0))
            except:
                traceback.print_exc()
            
            msg.set_payload(file_data)
            if filename:
                msg['Content-Id'] = '<%s@portaltransport>'%filename
                msg['Content-Disposition'] = 'attachment; filename="%s"'%filename
            Encoders.encode_base64(msg)
            message.attach(msg)

        return message

    def getMessage(self, info, headers={}, charset=None, text_format='plain', files=[]):
        """ """
        files = list(files)
        script = self.getBeforeScript()

        if callable(script):
            # fixme: is needed move to try except block?
            script.__of__(self)(
                info=info, headers=headers,
                charset=charset, text_format=text_format, files=files)

        if files:
            return self._getMultipartMessage(
                info, headers, charset, text_format, (), files)
        else:
            return self._getMessage(info, headers, charset, text_format)

    def getMultipartMessage(self, info, headers={}, charset=None,
                            text_format='plain', messages=(), files=[],
                            multipart_format='alternative'):
        """ messages: Message instances,
            files: 3 elems tuples (1: file_data, 2: content_type, 3: filename)
        """
        files = list(files)
        script = self.getBeforeScript()

        if callable(script):
            # fixme: is needed move to try except block?
            script.__of__(self)(
                info=info, headers=headers, charset=charset,
                text_format=text_format, files=files)
        
        return self._getMultipartMessage(
            info, headers, charset, text_format, messages, files, multipart_format)

    security.declareProtected(View, 'getBeforeScript')
    def getBeforeScript(self):
        """ """
        script = self.getField('before_script').get(self)

        if script:
            parent = aq_parent(aq_inner(self)).scripts
            try:
                #script_ob = parent._getOb(script)
                #portal = getToolByName(self, 'portal_url').getPortalObject()
                #return script_ob.__of__(portal)
                return parent._getOb(script)
            except AttributeError:
                pass

        return None

    security.declareProtected(View, 'getMailSubject')
    def getMailSubject(self):
        """ """
        return self.getField('mail_subject').get(self)

    security.declareProtected(View, 'getMailBody')
    def getMailBody(self):
        """ """
        return self.getField('mail_body').get(self)

    security.declarePublic('translate')
    def translate(self, msgid, domain='PortalTransport', mapping=None,
                  context=None, target_language=None, default=None):
        """ """
        try:
            trans = getGlobalTranslationService()

            portal = aq_parent(aq_parent(aq_parent(aq_inner(self))))

            try:
                res = trans.translate(domain, msgid, mapping=mapping, context=portal,
                                      target_language=target_language, default=default)
            except TypeError:
                res = trans.translate(domain, msgid, mapping=mapping, context=portal,
                                      target_language=target_language)
        
            if res is None:
                if default is not None:
                    return default
                else:
                    return msgid
            else:
                return res
        except:
            traceback.print_exc()
            return msgid

    security.declareProtected(ModifyPortalContent, 'Errors')
    def Errors(self):
        """ """
        return self.pt.pt_errors()


def modify_fti(fti):
    for a in fti['actions']:
        if a['id'] in ('metadata', 'references', ):
            a['visible'] = 0
    return fti

registerType( PT_MailTemplate )
