##
## Copyright (C) 2001 Thierry MICHEL <thierry@nekhem.com>
##  
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##  
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##  
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  
##

"""Z PoPy Database Adapter Package Registration"""

import sys, os, Globals
from PoPy_browser import PoPyConnectionBrowser, addPoPyConnectionBrowser,addPoPyConnectionForm

def initialize(context):
    "Initialize the product."
    try:
        context.registerClass(
            PoPyConnectionBrowser,
            constructors = (addPoPyConnectionForm,
                            addPoPyConnectionBrowser
                            ),
            icon='www/popy_icon.png'
            )
    except:
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        sys.stderr.write(string.join(traceback.format_exception(type,
                                                                val, tb), ''))
        del type, val, tb

