# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
Plone Article core classes for images and attachments and layout models
"""

# Zope imports
from AccessControl import ClassSecurityInfo

# CMF imports
from Products.CMFCore import CMFCorePermissions

# Archetypes imports
from Products.Archetypes.public import *

# PloneArticle imports
from Products.PloneArticle.Permissions import *

#                                                                           #
#                           MODEL SUPPORT                                   #
#                                                                           #


class ArticleModel:
    
    schema = Schema((
        # Model Mixin
        StringField('model',
                    accessor="getModel",
                    mutator="setModel",
                    default="plonearticle_model",
                    widget=SelectionWidget(
                        visible={'view' : 'hidden',
                                 'edit' : 'hidden'},
            )),
        ))

    security = ClassSecurityInfo()
    
    security.declareProtected(CMFCorePermissions.View, "getModel")
    def getModel(self):
        """
        getModel(self) => returns the Model id of the PloneArticle

        If the article has no model set, we fetch the default one.
        """
        model = getattr(self, 'model', None)
        
        # If we can't access the model template, we can't take the stored model
        if model:
            if not getattr(self, model, None):
                # Model not valid as template not accessible
                model = None
                
        # If the model exists, return it, otherwise take the default one
        if not model:
            model = self._getDefaultModel()
 
        return model

    #security.declareProtected(ArticleCore_editPermission, 'setModel')
    def setModel(self, model):
        """
        setModel(self) => sets the Model to serve as a layout for the PloneArticle
        """
        # Check lock status
        #self.checkLockStatus()

        template = getattr(self, model, None)
        if template:
            self.model = model
        else:
            raise ValueError, "Invalid model: '%s'" % (model, )

    security.declareProtected(CMFCorePermissions.View, "getModelTitle")
    def getModelTitle(self, model):
        """
        getModelTitle(self) => returns the Model Title for the Model that serves as a layout for the PloneArticle
                               First takes the customized models and then falls back to the StockModels.
        """
        template = getattr(self, model, None)
        if template:
            modeltitle = template.title_or_id()
        else:
            raise "Template does not exist"
        return modeltitle

    def _getDefaultModel(self):
        """
        _getDefaultModel(self) => returns the default Model to serve as a layout for the PloneArticle
        """
        model = "plonearticle_model"
        return model
