# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: config.py,v 1.9 2006/07/21 13:24:46 glenfant Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
import os

# CMF imports
from Products.CMFCore import CMFCorePermissions

# Check if we have to be in debug mode
if os.path.isfile(os.path.abspath(os.path.dirname(__file__)) + '/debug.txt'):
    DEBUG_MODE = 1
else:
    DEBUG_MODE = 0

# Set log options correctly
import Log
if DEBUG_MODE:
    Log.LOG_LEVEL = Log.LOG_DEBUG
else:
    Log.LOG_LEVEL = Log.LOG_NOTICE

# Detect Plone 2.1
try:
    from Products.CMFPlone.utils import transaction_note
except ImportError, e:
    HAS_PLONE_2_1 = False
else:
    HAS_PLONE_2_1 = True
    del transaction_note

# Detect LinguaPlone
try:
    from Products.LinguaPlone.public import registerType
except ImportError, e:
    HAS_LINGUA_PLONE = False
else:
    HAS_LINGUA_PLONE = True
    del registerType

TEXT_ALLOWABLE_CONTENT_TYPES = (
    'text/structured',
    'text/restructured',
    'text/html',
    'text/plain',
    'text/plain-pre',
    'text/python-source')

from Products.PloneArticle.Log import *
Log = Log
Log(LOG_NOTICE, "Starting %s at %d debug level" % (os.path.dirname(__file__), LOG_LEVEL, ))

GLOBALS = globals()
PROJECTNAME = "PloneArticle"
SKINS_DIR = 'skins'

# Configlets
plonearticle_prefs_configlet = {
    'id': 'plonearticle_prefs',
    'appId': PROJECTNAME,
    'name': 'PloneArticle Preferences',
    'action': 'string:$portal_url/plonearticle_prefs_form',
    'category': 'Products',
    'permission': (CMFCorePermissions.ManagePortal,),
    'imageUrl': 'PloneArticle.gif',
    }
