# -*- coding: utf-8 -*-
# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: PloneArticleMultiPage.py,v 1.8 2006/07/20 10:01:38 glenfant Exp $
"""
__author__  = ''
__docformat__ = 'restructuredtext'

# Zope imports
from ComputedAttribute import ComputedAttribute
from AccessControl import ClassSecurityInfo
from Acquisition import aq_base, \
    aq_inner, \
    aq_parent

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Plone imports
from Products.CMFPlone.PloneFolder import ReplaceableWrapper

    
# Archetypes imports
try:
    from Products.LinguaPlone.public import *
except ImportError:
    # No multilingual support
    from Products.Archetypes.public import *

# Products imports
from Products.PloneArticle.config import PROJECTNAME
from Products.PloneArticle.ATContentType import ATCTOrderedFolder

PloneArticleMultiPageSchema = ATCTOrderedFolder.schema.copy() + Schema((
    BooleanField(
        'viewTocFirst',
        accessor='viewTOCFirst',
        default=False,
        widget=BooleanWidget(
            label='View table of contents first',
            label_msgid='label_view_table_of_contents_first',
            i18n_domain='plonearticle',
        )
    ),
    BooleanField(
        'viewToc',
        accessor='viewTOC',
        edit_accessor='getViewTOCValue',
        default=True,
        widget=BooleanWidget(
            label='View table of contents in dropdown list',
            label_msgid='label_view_table_of_contents_in_dropdown_list',
            description='If you have checked properties to view TOC first, this property will not be applied.',
            description_msgid='description_view_table_of_contents_in_dropdown_list',
            i18n_domain='plonearticle',
        )
    ),
    ))

class PloneArticleMultiPage(ATCTOrderedFolder):
    """Content types to build multipage article"""

    content_icon   = 'multipagearticle_icon.gif'
    meta_type      = 'PloneArticleMultiPage'
    archetype_name = 'Multipage article'
    immediate_view = 'plonearticlemultipage_view'
    default_view   = 'plonearticlemultipage_view'
    suppl_views    = ()
    global_allow = True
    allowed_content_types = ('PloneArticle',)
    schema = PloneArticleMultiPageSchema
    security = ClassSecurityInfo()
    
    actions = (
        {
        'id'            : 'view',
        'name'          : 'View',
        'action'        : 'string:${folder_url}/',
        'permissions'   : (CMFCorePermissions.View, ),
        'category'      : 'object',
        'visible'       : 1,
        },)
    
    def __call__(self):
        """Redirect to first page or use default behaviour"""
        
        request = self.REQUEST
        force_toc = request.get('force_toc', False)
        pages = self.getPages();
        
        if force_toc or self.viewTOCFirst() or len(pages) == 0:
            return ATCTOrderedFolder.__call__(self)
        else:
            # redirect_home is false to avoir infinite loops
            return self.gotoPage(0)
    
    security.declarePublic('getPloneArticleMultiPage')
    def getPloneArticleMultiPage(self):
        """Get PloneArticle MultiPage"""
        
        utool = getToolByName(self, 'portal_url')
        return self.restrictedTraverse(utool.getRelativeContentURL(self))
    
    security.declareProtected(CMFCorePermissions.View, 'getViewTOCValue')
    def getViewTOCValue(self):
        """Returns edit value"""
        
        field = self.getField('viewToc')
        return field.get(self)
    
    security.declareProtected(CMFCorePermissions.View, 'viewTOC')
    def viewTOC(self):
        """Returns true if you can access TOC in dropdown menu"""
        
        field = self.getField('viewToc')
        value = field.get(self)
        
        if not value and not self.viewTOCFirst():
            return False
        
        return True
    
    security.declareProtected(CMFCorePermissions.View, 'getPageIds')
    def getPageIds(self):
        """Returns page ids. All pages are PloneArticle"""
        
        return [x.getId() for x in self.getPages()]
    
    security.declareProtected(CMFCorePermissions.View, 'getPages')
    def getPages(self):
        """Returns pages. All pages are PloneArticle"""
        
        return self.contentValues(filter={'portal_type' : 'PloneArticle'})
    
    security.declareProtected(CMFCorePermissions.View, 'getPageIndex')
    def getPageIndex(self, page):
        """Returns index of page. 0 is the first one"""
        
        search_page_id = page.getId()
        page_ids = self.getPageIds()
        
        for page_id in page_ids:
            if page_id == search_page_id:
                return page_id
        
        return -1
    
    security.declareProtected(CMFCorePermissions.View, 'gotoPage')
    def gotoPage(self, number):
        """Redirect to page n (number).
        0 is the first page"""
        
        request = self.REQUEST
        response = request.RESPONSE
        
        pages = self.getPages()
        pages_length = len(pages)
        
        if pages_length == 0 or number > pages_length - 1:
            return
        
        redirect_url = pages[number].absolute_url()
        return response.redirect(redirect_url)
    
    
    security.declareProtected(CMFCorePermissions.View, 'getNavigation')
    def getNavigation(self, current):
        """Returns structure to build navigation.
        id, title, url, selected"""
        
        current_id = current.getId()
        pages = self.getPages()
        navigation = {}
        navigation['selected'] = -1
        navigation['list'] = []
        url = self.absolute_url()
        index = 0
        
        for page in pages:
            item = {}
            page_id = page.getId()
            item['id'] = page_id
            item['title'] = page.title_or_id()
            item['url'] = page.absolute_url()
            item['selected'] = False
            
            if current_id == page_id:
                item['selected'] = True
                navigation['selected'] = index
                
            navigation['list'].append(item)
            index += 1
        
        return navigation
    
registerType(PloneArticleMultiPage, PROJECTNAME)

