# -*- coding: utf-8 -*-
"""
$Id: utils.py 33405 2006-02-23 20:13:31Z madarche $
"""
__author__  = ''
__docformat__ = 'restructuredtext'




# Python imports
import unicodedata
import string
from StringIO import StringIO
import re
import urlparse
from AccessControl import ClassSecurityInfo

security = ClassSecurityInfo()

# Make fckAbsUrl importable TTW
security.declarePublic('fckAbsUrl')
def fckAbsUrl(obj_url, portal_url, server_url, text):
   """
   Find real absolute url for href and img
   """
   # obj_url = self.absolute_url()
   html = text
   portal_path = portal_url.replace(server_url,'')

   # Method to replace src and href link by new one
   def replace_locale_url(match):
       """Compute local url
       """
       url = str(match.group('url'))
       attribute =  str(match.group('attribute'))
       if match.group('protocol') is not None:
           url = '%s%s' % (match.group('protocol'), url)

       elif not ('resolveuid' in url.lower() or url.startswith('\x23')):
         try:
            url=urlparse.urljoin (obj_url, url)
         except:
            pass 

       url = url.replace(portal_url, portal_path)

              

       return '%s="%s"' % (attribute,url) 
       return match.group(0)  

   abs_url = re.compile('(?P<attribute>href|src)\s*=\s*([\'\"])(?P<protocol>(ht|f)tps?)?(?P<url>[^\"\']*)\\2', re.IGNORECASE)
   html = abs_url.sub(replace_locale_url, html) 

   return html 


# Make fckCreateValidZopeId importable TTW
security.declarePublic('fckCreateValidZopeId')
def fckCreateValidZopeId(s):
    """
    Return a valid Zope id from the given string
    """
    id = s.decode('utf-8')
    id = unicodedata.normalize('NFKD', id)
    id = id.encode('ascii', 'ignore')

    # remove invalid ascii chars for ids
    new_id = ''
    for a in id:
        if a in string.digits or a in string.lowercase or a in string.uppercase or a=='.' or a==' ' or a=='-' or a=='_':
            new_id += a
    new_id = new_id.replace(' ','_')
    new_id = re.sub("_+","_", new_id)
    new_id = new_id.strip('_')
    # ids in lower case
    return new_id.lower()

# Make fckDefaultToolbar importable TTW
security.declarePublic('fckDefaultToolbar')
def fckDefaultToolbar():
    """
    Return a string for default toolbar Custom configuration
    """
    toolbar = """[
 ['Source','DocProps','-','Preview','-','Templates'],
 ['Cut','Copy','Paste','PasteText','PasteWord','-','Print','SpellCheck'],
 ['Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'],
 ['Bold','Italic','Underline','StrikeThrough','-','Subscript','Superscript'],
 ['OrderedList','UnorderedList','-','Outdent','Indent'],
 ['JustifyLeft','JustifyCenter','JustifyRight','JustifyFull'],
 ['Link','Unlink','Anchor'],
 ['Image','Flash','Table','Rule','SpecialChar','PageBreak','Smiley','UniversalKey'],
 ['Form','Checkbox','Radio','TextField','Textarea','Select','Button','ImageButton','HiddenField'],
 '/',
 ['Style','FontFormat','FontName','FontSize'],
 ['TextColor','BGColor'],
 ['About']
]"""

    return toolbar
