# Create .metadata files in the current folder to support FckHTTPCache
# at first zope fckeditor integration

import os

file_types = ['.jpg', '.gif', '.png', '.css.dtml', '.css', '.js', '.js.dtml']

metadata  = '[default]'
metadata += '\n'
metadata += 'title='
metadata += '\n'
metadata += 'cache=FckHTTPCache'
metadata += '\n'

def create_metadata(dir):
    filenames = os.listdir(dir)
    for filename in filenames:
     for file_type in file_types:
        if filename.endswith(file_type):
            if filename + '.metadata' in filenames:
                pass
            else:
                f = open(os.path.join(dir, filename) + '.metadata','w')
                f.write(metadata)
                f.close()
                
def createMetadataInSubFolders(dir):
     for root, folders, files in os.walk(dir, topdown=True):
         for folder in folders :
             workingFolder = os.path.join(root,folder)
             create_metadata(workingFolder)


if __name__=='__main__':
    createMetadataInSubFolders(os.curdir)
