# (C) Copyright 2005 Nuxeo SARL <http://nuxeo.com>
# Author: Lennart Regebro <regebro@nuxeo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Id: install.py 10227 2005-04-01 16:51:45Z regebro $

from zLOG import LOG, INFO, DEBUG
from Products.CMFCore.utils import getToolByName, _marker

log_ok_message = '...Already correctly installed'

class CMFonFiveInstaller:
    """A simplified version of the installers from CPSInstaller"""

    # Sure, it's overkill, but easier that writing things from scratch. /Lennart
   
    product_name = 'CMFonFive'

    def __init__(self, context):
        """CMFInstaller initialization

        product_name should be set as a class attribute when subclassing,
        but must be passed if you are not subclassing the installer.

        is_main_installer should be se to 0 if this installer is called
        from another installer to prevent multiple reindexing of catalogs
        and similar actions that only needs to be done once.
        """
        self.context = context
        self.messages = []
        self.portal = context.portal_url.getPortalObject()

    #
    # Logging
    #
    def log(self, message):
        self.messages.append(message)
        LOG(self.product_name, INFO, message)

    def logOK(self):
        self.messages[-1] = self.messages[-1] + log_ok_message
        #self.log(log_ok_message)

    def flush(self):
        log = '\n'.join(self.messages)
        self.messages = []
        return log

    def logResult(self):
        if not self.isMainInstaller():
            return self.flush()
        # Wrap HTML around it if it's the main installer.
        return '''<html><head><title>%s</title></head>
            <body><pre>%s</pre></body></html>''' % (
            self.product_name, self.flush() )
    #
    # Other support methods
    #
    def portalHas(self, id):
        return id in self.portal.objectIds()

    def getTool(self, id, default=_marker):
        """Gets the tool by id
        
        If No default is given, it will raise an error.
        """
        return getToolByName(self.portal, id, default)
    #
    # Methods to setup and manage actions
    #
    def verifyActionProvider(self, action_provider):
        self.log('Verifying action provider %s' % action_provider)
        atool = self.getTool('portal_actions')
        if action_provider in atool.listActionProviders():
            self.logOK()
        else:    
            atool.addActionProvider(action_provider)
            self.log(' Installed')
        
    def verifyTool(self, toolid, product, meta_type):
        self.log('Verifying tool %s' % toolid)
        if self.portalHas(toolid):
            tool = self.getTool(toolid)
            if tool.meta_type == meta_type:
                self.logOK()
                return
            self.log(' Deleting old %s tool' % tool.meta_type)
            self.portal.manage_delObjects([toolid])
        self.log(' Adding')
        self.portal.manage_addProduct[product].manage_addTool(meta_type)


def install(self):
    installer = CMFonFiveInstaller(self)
    installer.verifyTool('portal_fiveactions', 'CMFonFive', 'Five Actions Tool')
    installer.verifyActionProvider('portal_fiveactions')
    return installer.flush()
