
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass

from ExtensionClass import Base
from Acquisition import Implicit, aq_parent
from OFS.Traversable import Traversable

from OFS.Cache import ChangeCacheSettingsPermission
from Products.CMFCore import CMFCorePermissions

from Products.CMFDefault.Image import Image
import OFS.Image
from BTrees.OOBTree import OOBTree

from cgi import escape
from cStringIO import StringIO
import sys
from zLOG import LOG, ERROR

try: 
    import PIL.Image
    isPilAvailable = 1
except ImportError: 
    isPilAvailable = 0

factory_type_information = {
    'id'             : 'Photo',
    'meta_type'      : 'Photo',
    'description'    : 'Photos objects can be embedded in Portal documents.',
    'icon'           : 'image_icon.gif',
    'product'        : 'CMFPhoto',
    'factory'        : 'addPhoto',
    'immediate_view' : 'image_edit_form',
    'actions'        :
    ( { 'id'            : 'view',
        'name'          : 'View',
        'action'        : 'photo_view',
        'permissions'   : (CMFCorePermissions.View, )
        },
      { 'id'            : 'edit',
        'name'          : 'Properties',
        'action'        : 'portal_form/image_edit_form',
        'permissions'   : (CMFCorePermissions.ModifyPortalContent, )
        },
      { 'id'            : 'metadata',
        'name'          : 'Metadata',
        'action'        : 'portal_form/metadata_edit_form',
        'permissions'   : (CMFCorePermissions.ModifyPortalContent, )
        }
      )
    }

def addPhoto( self
              , id
              , title=''
              , file=''
              , content_type=''
              , precondition=''
              , subject=()
              , description=''
              , contributors=()
              , effective_date=None
              , expiration_date=None
              , format='image/png'
              , language=''
              , rights=''
              ):
    """
    Add an Photo
    """

    # cookId sets the id and title if they are not explicity specified
    id, title = OFS.Image.cookId(id, title, file)

    self=self.this()

    # Instantiate the object and set its description.
    iobj = Photo( id, title, '', content_type, precondition, subject
                  , description, contributors, effective_date, expiration_date
                  , format, language, rights
                  )

    # Add the Photo instance to self
    self._setObject(id, iobj)

    # 'Upload' the photo.  This is done now rather than in the
    # constructor because it's faster (see File.py.)
    self._getOb(id).manage_upload(file)


class DynVariantWrapper(Base):
    """
    provide a transparent wrapper from photo to dynvariant
    call it with url ${photo_url}/variant/${variant}
    """

    def __of__(self, parent):
        return parent.Variants()


class DynVariant(Implicit, Traversable):
    """
    provide access to the variants
    """
    def __init__(self):
	pass

    def __getitem__(self, name):
	if self.checkForVariant(name):
            return self.getPhoto(name).__of__(aq_parent(self))
	else:
	    return aq_parent(self)


class Photo(Image):
    """
    Implements a Photo, a scalable image
    """


    __implements__ = ( Image.__implements__ ,)


    meta_type = 'Photo'


    def __init__( self
                , id
                , title=''
                , file=''
                , content_type=''
                , precondition=''
                , subject=()
                , description=''
                , contributors=()
                , effective_date=None
                , expiration_date=None
                , format='image/png'
                , language='en-US'
                , rights=''
                ):
        Image.__init__(self, id, title, file, content_type, precondition,
                       subject, description, contributors, effective_date,
                       expiration_date, format, language, rights)
        self._photos = OOBTree()


    security = ClassSecurityInfo()

    # make image variants accesable via url
    variant=DynVariantWrapper()
    security.declareProtected(CMFCorePermissions.View, 'Variants')
    def Variants(self):
        # Returns a variants wrapper instance
        return DynVariant().__of__(self) 

    security.declareProtected(CMFCorePermissions.View, 'getPhoto')
    def getPhoto(self,size):
        '''returns the Photo of the specified size'''
        return self._photos[size]

    security.declareProtected(CMFCorePermissions.View, 'getDisplays')
    def getDisplays(self):
        result = []

        for name, size in self.photo_display_sizes().items():
            result.append({'name':name, 'label':'%s (%dx%d)' % (name, size[0], size[1]),'size':size})

        result.sort(lambda d1,d2: cmp(d1['size'][0]*d1['size'][0],d2['size'][1]*d2['size'][1])) #sort ascending by size
        return result

    security.declarePrivate('checkForVariant')
    def checkForVariant(self, size):
	"""Create variant if not there."""
        if size in self.photo_display_sizes().keys():
	    # Create resized copy, if it doesnt already exist
            if not self._photos.has_key(size):
                self._photos[size] = OFS.Image.Image(size, size,
                                                     self._resize(self.photo_display_sizes().get(size, (0,0))))
            # a copy with a content type other than image/* exists, this
            # probably means that the last resize process failed. retry
            elif not self._photos[size].getContentType().startswith('image'):
                self._photos[size] = OFS.Image.Image(size, size,
                                                     self._resize(self.photo_display_sizes().get(size, (0,0))))

            return 1

        else: return 0

    security.declareProtected(CMFCorePermissions.View, 'index_html')
    def index_html(self, REQUEST, RESPONSE, size=None):
        """Return the image data."""
	if self.checkForVariant(size):
            return self.getPhoto(size).index_html(REQUEST, RESPONSE)

        return Photo.inheritedAttribute('index_html')(self, REQUEST, RESPONSE)

    security.declareProtected(CMFCorePermissions.View, 'tag')
    def tag(self, height=None, width=None, alt=None,
            scale=0, xscale=0, yscale=0, css_class=None, title=None, size='original', **args):
        """ Return an HTML img tag (See OFS.Image)"""

        # Default values
        w=self.width
        h=self.height

        if height is None or width is None:

            if size in self.photo_display_sizes().keys():
                if not self._photos.has_key(size):
                    # This resized image isn't created yet.
                    # Calculate a size for it
                    x,y = self.photo_display_sizes().get(size)
                    try:
                        if self.width > self.height:
                            w=x
                            h=int(round(1.0/(float(self.width)/w/self.height)))
                        else:
                            h=y
                            w=int(round(1.0/(float(self.height)/x/self.width)))
                    except ValueError:
                        # OFS.Image only knows about png, jpeg and gif.
                        # Other images like bmp will not have height and
                        # width set, and will generate a ValueError here.
                        # Everything will work, but the image-tag will render 
                        # with height and width attributes.
                        w=None
                        h=None
                else:
                    # The resized image exist, get it's size
                    photo = self._photos.get(size)
                    w=photo.width
                    h=photo.height

        if height is None: height=h
        if width is None:  width=w

        # Auto-scaling support
        xdelta = xscale or scale
        ydelta = yscale or scale

        if xdelta and width:
            width =  str(int(round(int(width) * xdelta)))
        if ydelta and height:
            height = str(int(round(int(height) * ydelta)))

        result='<img src="%s/variant/%s"' % (self.absolute_url(), escape(size))

        if alt is None:
            alt=getattr(self, 'title', '')
        result = '%s alt="%s"' % (result, escape(alt, 1))

        if title is None:
            title=getattr(self, 'title', '')
        result = '%s title="%s"' % (result, escape(title, 1))

        if height:
            result = '%s height="%s"' % (result, height)

        if width:
            result = '%s width="%s"' % (result, width)

        if not 'border' in [ x.lower() for x in  args.keys()]:
            result = '%s border="0"' % result

        if css_class is not None:
            result = '%s class="%s"' % (result, css_class)

        for key in args.keys():
            value = args.get(key)
            result = '%s %s="%s"' % (result, key, value)

        return '%s />' % result

    security.declarePrivate('update_data')
    def update_data(self, data, content_type=None, size=None):
        """
        Update/upload image -> remove all copies
        """
        Image.update_data(self, data, content_type, size)
        self._photos = OOBTree()
        
    def _resize(self, size, quality=100):
        """Resize and resample photo."""
        image = StringIO()

        width, height = size

        try:
            if isPilAvailable:
                img = PIL.Image.open(StringIO(str(self.data)))
                fmt = img.format
                # Resize photo
                img.thumbnail((width, height))
                # Store copy in image buffer
                img.save(image, fmt, quality=quality)
            else:
                if sys.platform == 'win32':
                    from win32pipe import popen2
                    imgin, imgout = popen2('convert -quality %s -geometry %sx%s - -'
                                           % (quality, width, height), 'b')
                else:
                    from popen2 import Popen3
                    convert=Popen3('convert -quality %s -geometry %sx%s - -'
                                           % (quality, width, height))
                    imgout=convert.fromchild
                    imgin=convert.tochild

                imgin.write(str(self.data))
                imgin.close()
                image.write(imgout.read())
                imgout.close()

                #Wait for process to close if unix. Should check returnvalue for wait
                if sys.platform !='win32':
                    convert.wait()

                image.seek(0)
                
        except Exception, e:
            LOG('CMFPhoto.Photo', ERROR, 'Error while resizing photo', e)
                
        return image

    security.declareProtected(CMFCorePermissions.View, 'getEXIF')
    def getEXIF(self):
        """
        Extracts the exif metadata from the image and returns
        it as a hashtable
        """
        import EXIF

        try:
            data = EXIF.process_file(StringIO(str(self.data)))
        except:
            data = {}
        if not data:
            data = {}

        keys = data.keys()
        keys.sort()

        result = {}

        for key in keys:
            if key in ('JPEGThumbnail', 'TIFFThumbnail'):
                continue
            try:
                result[key] = str(data[key].printable)
            except:
                pass
        return result

    security.declareProtected(ChangeCacheSettingsPermission, 'ZCacheable_setManagerId')
    def ZCacheable_setManagerId(self, manager_id, REQUEST=None):
        '''Changes the manager_id for this object.
           overridden because we must propagate the change to all variants'''
        for size in self._photos.keys():
            variant = self.getPhoto(size).__of__(self)
            variant.ZCacheable_setManagerId(manager_id)
        return Photo.inheritedAttribute('ZCacheable_setManagerId')(self, manager_id, REQUEST)


InitializeClass(Photo)
