############################################################################
#                                                                          #
#             copyright (c) 2004 ITB, Humboldt-University Berlin           #
#             written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                          #
############################################################################

"""RISRenderer (Research Information Systems/Reference Manager) class"""

# Python stuff
import os

# Zope stuff
from Globals import InitializeClass
from App.Dialogs import MessageDialog

# CMF stuff
from Products.CMFCore.utils import getToolByName

# Bibliography stuff
from Products.CMFBibliographyAT.tool.renderers.base \
     import IBibliographyRenderer, BibliographyRenderer


class RISRenderer(BibliographyRenderer):
    """
    specific RIS renderer
    (Research Information Systems/Reference Manager)
    depends on the BibTeX renderer
    """

    __implements__ = (IBibliographyRenderer ,)

    meta_type = "RIS Renderer"

    format = {'name':'RIS',
              'extension':'ris'}

    def __init__(self,
                 id = 'ris',
                 title = "depends on the bibtex renderer"):
        """
        initializes id and title
        """
        self.id = id
        self.title = title

    def render(self, object):
        """
        renders a bibliography object in RIS format
        (Research Information Systems/Reference Manager)
        """
        bib_tool = getToolByName(object, 'portal_bibliography')
        bibtex_source = bib_tool.render(object, 'bib')

        # open a pipe
        (fi, fo, fe) = os.popen3('bib2xml | xml2ris', 't')
        # provide the input
        fi.write(bibtex_source)
        fi.close()
        # get the output
        ris = fo.read()
        fo.close()
        # get the staus/error message
        # (this isn't used but we don't want it in the output)
        error = fe.read()
        fe.close()
        # done
        return ris


# Class instanciation
InitializeClass(RISRenderer)


def manage_addRISRenderer(self, REQUEST=None):
    """ """
    try:
        self._setObject('ris', RISRenderer())
    except:
        return MessageDialog(
            title='Bibliography tool warning message',
            message='The renderer you attempted to add already exists.',
            action='manage_main')
    return self.manage_main(self, REQUEST)
