from Products.CMFCore.utils import getToolByName
from Products.Archetypes.public import *

from Products.ATSchemaEditorNG.ParentManagedSchema import ParentManagedSchema
from Products.ATSchemaEditorNG.SchemaEditor import SchemaEditor
from Products.ATSchemaEditorNG.config import ATSE_MANAGED_NONE, \
     ATSE_MANAGED_FULL
from Products.ATSchemaEditorNG import util

schema = BaseSchema

schema1= BaseSchema + Schema(( StringField('additionalField'), ))

schema3 = BaseSchema + Schema((
    StringField('atse_managed_full',
                atse_managed=ATSE_MANAGED_FULL,
                schemata='atse_manage_test',
                ),
    StringField('atse_managed_none',
                atse_managed=ATSE_MANAGED_NONE,
                schemata='atse_manage_test',
                ),
    StringField('atse_managed_none1',
                atse_managed=ATSE_MANAGED_NONE,
                schemata='atse_manage_test',
                ),
    ))

schema4 = BaseSchema + Schema((
    StringField('implicit',
                ),
    StringField('explicit_autocreate',
                accessor='getExplicit_autocreate',
                mutator='setExplicit_autocreate',
                ),
    StringField('explicit_def',
                accessor='getExplicit_def',
                mutator='setExplicit_def',
                ),
    ))

class Container(SchemaEditor, BaseFolder):
    """
    Container to act as host for schema editing.
    """
    portal_type = "Container"
    def manage_afterAdd(self, item, container):
        """ """
        # do not show metadata fieldset
        self.atse_registerObject( Target1, ('metadata', ))
        #self.schema_editor_tool.atse_registerObject( Target1, ('metadata', ))
        BaseFolder.manage_afterAdd(self, item, container)

registerType(Container)

class Target1(ParentManagedSchema, BaseContent):
    """ Target content type to edit schema on """
    meta_type = portal_type = "Target1"
    schema = schema1

registerType(Target1)

class Target2(ParentManagedSchema, BaseContent):
    """ Target content type to edit schema on """
    meta_type = portal_type = "Target2"

registerType(Target2)

class Target3(ParentManagedSchema, BaseContent):
    """ Target content type to edit schema on """
    meta_type = portal_type = "Target3"
    schema = schema3

registerType(Target3)

class Target4(ParentManagedSchema, BaseContent):
    """ Target content type to edit schema on """
    meta_type = portal_type = "Target4"
    schema = schema4

    def manage_afterAdd(self, item, container):
        BaseContent.manage_afterAdd(self, item, container)
        self.accessor_called = False
        self.mutator_called = False

    def getExplicit_def(self):
        self.getField('explicit_def').get(self)
        self.accessor_called = True

    def setExplicit_def(self, value):
        self.getField('explicit_def').set(self, value)
        self.mutator_called = True

registerType(Target4)
