package ONVIF::PTZ::Types::JpegOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ResolutionsAvailable_of :ATTR(:get<ResolutionsAvailable>);
my %FrameRateRange_of :ATTR(:get<FrameRateRange>);
my %EncodingIntervalRange_of :ATTR(:get<EncodingIntervalRange>);

__PACKAGE__->_factory(
    [ qw(        ResolutionsAvailable
        FrameRateRange
        EncodingIntervalRange

    ) ],
    {
        'ResolutionsAvailable' => \%ResolutionsAvailable_of,
        'FrameRateRange' => \%FrameRateRange_of,
        'EncodingIntervalRange' => \%EncodingIntervalRange_of,
    },
    {
        'ResolutionsAvailable' => 'ONVIF::PTZ::Types::VideoResolution',
        'FrameRateRange' => 'ONVIF::PTZ::Types::IntRange',
        'EncodingIntervalRange' => 'ONVIF::PTZ::Types::IntRange',
    },
    {

        'ResolutionsAvailable' => 'ResolutionsAvailable',
        'FrameRateRange' => 'FrameRateRange',
        'EncodingIntervalRange' => 'EncodingIntervalRange',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::JpegOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
JpegOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ResolutionsAvailable


=item * FrameRateRange


=item * EncodingIntervalRange




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::JpegOptions
   ResolutionsAvailable =>  { # ONVIF::PTZ::Types::VideoResolution
     Width =>  $some_value, # int
     Height =>  $some_value, # int
   },
   FrameRateRange =>  { # ONVIF::PTZ::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   EncodingIntervalRange =>  { # ONVIF::PTZ::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

