package ONVIF::PTZ::Types::SourceIdentification;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %Token_of :ATTR(:get<Token>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Name
        Token
        Extension

    ) ],
    {
        'Name' => \%Name_of,
        'Token' => \%Token_of,
        'Extension' => \%Extension_of,
    },
    {
        'Name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Token' => 'ONVIF::PTZ::Types::ReferenceToken',
        'Extension' => 'ONVIF::PTZ::Types::SourceIdentificationExtension',
    },
    {

        'Name' => 'Name',
        'Token' => 'Token',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::SourceIdentification

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SourceIdentification from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Name


=item * Token


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::SourceIdentification
   Name =>  $some_value, # string
   Token => $some_value, # ReferenceToken
   Extension =>  { # ONVIF::PTZ::Types::SourceIdentificationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

