/*  zomghelper, an information extractor for Ogg Vorbis files
    Copyright (C) 2005, 2007  Clint Adams

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#ifdef HAVE_VORBIS_VORBISFILE_H
# include <vorbis/vorbisfile.h>
#else
# error install libvorbis-dev
#endif

int main(int argc, char **argv) {
	FILE *f;
	OggVorbis_File vf;
	double k;
	vorbis_comment *com;
	char **soc;

	if (argc!=2)
		exit(1);

	f = fopen(argv[1], "r");
	if (f==NULL)
		exit(2);

	ov_open(f, &vf, NULL, 0);

	k = ov_time_total(&vf,-1);

	com = ov_comment(&vf,-1);

	printf("ZOMGSECS: %d\n", (int)ceil(k));

	soc = com->user_comments;

	while(*(soc)) {
		printf("%s\n", *soc++);
	}
}
