/* (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_key_h
#define zoem_key_h

#include "filter.h"
#include "dict.h"

#include "util/ting.h"
#include "util/io.h"
#include "util/types.h"
#include "util/hash.h"


mcxstatus usrDictPush
(  const char* label
)  ;

mcxstatus usrDictPop
(  const char* label
)  ;

void  yamKeySet
(  const char* key
,  const char* val
)  ;

void  yamKeyDef
(  const char* key
,  const char* val
)  ;

mcxTing* yamKeyDelete
(  mcxTing*  key
)  ;

mcxbool yamKeyDeletex
(  const char* key
)  ;

mcxTing* yamKeyGet
(  mcxTing*  key
)  ;

mcxTing* yamKeyGetLocal
(  mcxTing*  key
)  ;

mcxTing* yamKeyInsert
(  mcxTing*      key
,  const char*  valstr
)  ;

void mod_key_init
(  int n
)  ;

void mod_key_exit
(  void
)  ;

void yamKeyStats
(  void
)  ;

void yamKeyList
(  const char* mode
)  ;

void keyULimit
(  int   user
,  int   dollar
)  ;

#endif


