/* (c) Copyright 2001, 2002, 2003, 2004, 2005 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

/* TODO.
 *    Most of the logic is concentrated in sinkPush. It is a bit dense
 *    and underdocumented.
*/


#include <stdio.h>

#include "filter.h"
#include "util.h"
#include "entry.h"
#include "key.h"
#include "read.h"
#include "sink.h"

#include "util/hash.h"
#include "util/ting.h"
#include "util/types.h"
#include "util/io.h"
#include "util/minmax.h"


#ifdef DEBUG
#  define DEBUG_BU DEBUG
#endif

#define DEBUG 0

typedef struct
{  mcxLink*       sp
;
}  busystack      ;


static busystack  bst         =  {  NULL  }  ;
static busystack* busystack_g =  &bst        ;
       sink* sink_default_g   =  NULL        ;
static int   sink_fltidx_g    =  0           ;    /* ZOEM_FILTER_NONE  */
static mcxHash*   wrtTable_g  =  NULL        ;    /* open output files */


void mod_sink_init
(  int   n
)
   {  wrtTable_g        =  yamHashNew(n)
   ;  busystack_g->sp   =  mcxLinkNew(10, NULL, MCX_GRIM_ARITHMETIC)
;  }


void warn_stack_free
(  lblStack** st
,  const char* type
)
   {  mcxLink* lk = (*st)->sp
   ;  while (lk->prev)
         mcxErr("env", "open %s <%s>", type, ((mcxTing*)lk->val)->str)
      ,  lk = lk->prev
   ;  ting_stack_free(st)
;  }


void sinkFree
(  sink* sk
)
   {  filterFree(sk->fd)
   ;  warn_stack_free(&(sk->xmlStack), "tag")
   ;  dictStackFree(&(sk->dlrStack))
   ;  mcxFree(sk->fname)
   ;  mcxFree(sk)
;  }


/* this was part of attempt to solve system#3 problems,
 * but the problem was pbb entirely due to unflushed buffers.
 * fsync does not seem totally portable.
*/
#if 0
void yamOutputFDSync
(  void
)
   {  mcxHashWalk* walk    =  mcxHashWalkNew(wrtTable_g)
   ;  mcxKV* kv
   ;  while((kv = mcxHashWalkStep(walk)))
      {  mcxIO *xf = (mcxIO*) kv->val
      ;  fsync(fileno(xf->fp))
   ;  }
   }

void yamOutputFDClose
(  void
)
   {  mcxHashWalk* walk    =  mcxHashWalkNew(wrtTable_g)
   ;  mcxKV* kv
   ;  while((kv = mcxHashWalkStep(walk)))
      {  mcxIO *xf = (mcxIO*) kv->val
      ;  close(fileno(xf->fp))
   ;  }
   }
#endif


void yamOutputClose
(  const char*  s
)
   {  mcxTing* fname = mcxTingNew(s)
   ;  mcxKV* kv = mcxHashSearch(fname, wrtTable_g, MCX_DATUM_FIND)
   ;  if (kv)
      {  mcxIO* xf = (mcxIO*) kv->val
      ;  fflush(xf->fp)
      ;  mcxIOclose(xf)
   ;  }
      /* keep the object around; repeated \writeto should append
       * (this might be settable someday)
      */
      mcxTingFree(&fname)
;  }


sink* sinkNew
(  mcxIO* xf
)
   {  sink* sk       =  mcxAlloc(sizeof(sink), EXIT_ON_FAIL)
   ;  sk->fd         =  xf ? filterNew(xf->fp) : NULL
   ;  sk->xmlStack   =  ting_stack_new(10)
   ;  sk->dlrStack   =  dictStackNew(20, 100)
   ;  sk->fname      =  mcxTingStr(xf->fn)
   ;  return sk
;  }


mcxIO* yamOutputNew
(  const char*  s
)
   {  mcxIO *xf            =  NULL
   ;  mcxTing *fname       =  mcxTingNew(s)
   ;  mcxKV *kv

   ;  if (fname->len > 1024)
      {  yamErr
         (  "yamOutputNew"
         ,  "output file name expansion too <%d> long"
         ,  fname->len
         )
      ;  mcxTingFree(&fname)
      ;  return NULL
   ;  }

      kv = mcxHashSearch(fname, wrtTable_g, MCX_DATUM_FIND)

   ;  if (!kv)
      {  xf = mcxIOnew(fname->str, "w")
      ;  kv = mcxHashSearch(fname, wrtTable_g, MCX_DATUM_INSERT)
      ;  kv->val = xf
   ;  }
      else
      {  xf = (mcxIO*) kv->val
      ;  if (!xf->fp)            /* used by writeto wrapper */
         mcxIOrenew(xf, NULL, "a")
      ;  mcxTingFree(&fname)
   ;  }

      if (!xf->fp && mcxIOopen(xf, RETURN_ON_FAIL) != STATUS_OK)
      {  yamErr
         (  "yamOutputNew"
         ,  "can not open file <%s> for writing\n"
         ,  s
         )
      ;  if (!(kv = mcxHashSearch(xf->fn, wrtTable_g, MCX_DATUM_DELETE)))
         {  yamErr
            (  "yamOutputNew panic"
            ,  "can not find IO object for stream <%s>"
            ,  xf->fn->str
            )
         ;  return NULL
      ;  }
         fname = ((mcxTing*) (kv->key))
      ;  mcxTingFree(&fname)
         /* might have xf->usr (in renewal case) should free it as well
          * (check though)
         */
      ;  mcxIOfree(&xf)
      ;  return NULL
   ;  }

      if (!xf->usr)
      xf->usr = sinkNew(xf)
   ;  else
      ((sink*) xf->usr)->fd->fp = xf->fp
            /* this case is relevant for "a"(ppend) renewal (only),
             * as the fp will have changed
            */
   ;  return xf
;  }


void yamIOfree_v
(  void*    xfpp
)
   {  mcxIO* xf =  *((mcxIO**) xfpp)
   ;  sinkFree((sink*) xf->usr)
   ;  xf->usr = NULL
   ;  if (1)
      mcxIOfree(&xf)
;  }


void mod_sink_exit
(  void
)
   {  mcxHashFree(&wrtTable_g, mcxTingFree_v, yamIOfree_v)
   ;  mcxLinkFree(&(busystack_g->sp), NULL)
;  }


void sink_stack_debug
(  void
)
   {  mcxLink* lk = busystack_g->sp

   ;  if (!DEBUG)
      return

   ;  while (lk)
      {  busysink* bs = lk->val
      ;  if (bs && bs->sk)
         fprintf
         (  stderr
         ,  "name [%s] fd [%p], fp [%p]\n"
         ,  bs->sk->fname, (void*) bs->sk->fd, (void*) bs->sk->fd->fp
         )
      ;  lk = lk->prev
   ;  }
   }


void sinkSetFNOUT
(  void
)
   {  yamKeySet("__fnout__", sink_default_g->fname)
;  }


busysink* new_busy_sink
(  void
)
   {  return mcxAlloc(sizeof(busysink), EXIT_ON_FAIL)
;  }

/* NOTE.
 *    In the stack of sinks the same sink may occur multiple times.
 *    when we issue writeto (redirect current default output stream)
 *    it has to be updated in all places.
*/

void sinkPush
(  sink*    new_active_sink
,  int      fltidx
)
   {  mcxLink* lk    =  busystack_g->sp
   ;  busysink* curr =  lk->val
   ;  busysink* next =  NULL

   ;  mcxbool write_to  =  fltidx < 0
   ;  mcxbool bootstrap =  !sink_default_g

   ;  mcxbool change_default = write_to || bootstrap

;if (DEBUG)
   fprintf(stderr, "=== %p %d\n", (void*) new_active_sink, fltidx)

   ;  if (change_default)
      {  if (sink_default_g && new_active_sink)
         while (lk && curr)               /* find all occurrences of target */
         {  if (curr->sk == sink_default_g)
            curr->sk = new_active_sink    /* old sk is cached in wrtTable_g */
         ;  lk = lk->prev
         ;  curr = lk->val
      ;  }
;if
   (DEBUG) fprintf (stderr, "--> change sink to %s\n", new_active_sink->fname)

      ;  if (bootstrap)
         sink_fltidx_g  = fltidx
      ;  if (new_active_sink)
         sink_default_g = new_active_sink

      ;  sinkSetFNOUT()
   ;  }

      if (write_to)
      return                              /* otherwise set up stack */

   ;  next = new_busy_sink()              /* uninitialized */

   ;  if (!new_active_sink)               /* dofile or chunk */
      next->sk = sink_default_g
   ;  else
      next->sk = new_active_sink

   ;  lk = mcxLinkAfter(busystack_g->sp, next)
   ;  busystack_g->sp=  lk
;  }



void sinkPop
(  sink* sk
)
   {  mcxLink* lk    =  busystack_g->sp->prev
   ;  busysink* curr =  busystack_g->sp->val  

;if (DEBUG)
   fprintf
   (  stderr
   ,  "--> pop %s curr %s\n"
   ,  curr->sk->fname
   ,  sk ? sk->fname : "none"
   )

   ;  mcxFree(curr)
   ;  mcxLinkDelete(busystack_g->sp)
   ;  busystack_g->sp = lk
;  }


keyDict* sinkGetDLRtop
(  void
)
   {  return ((busysink*) busystack_g->sp->val)->sk->dlrStack->top
;  }


keyDict* sinkGetDLRdefault
(  void
)
   {  return sink_default_g->dlrStack->top
;  }


dictStack* sinkGetDLR
(  void
)
   {  return ((busysink*) busystack_g->sp->val)->sk->dlrStack
;  }


lblStack* sinkGetXML
(  void
)
   {  return ((busysink*) busystack_g->sp->val)->sk->xmlStack
;  }


const char* sinkGetDefaultName
(  void
)
   {  return sink_default_g->fname
;  }



mcxstatus sinkDictPush
(  const char* label
)
   {  dictStack* dlr = sinkGetDLR()
   ;  return dictStackPush(dlr, 16, label)
;  }


mcxstatus sinkDictPop
(  const char* name
)
   {  dictStack* dlr = sinkGetDLR()
   ;  return dictStackPop(dlr, "dollar", name)
;  }



#ifdef DEBUG_BU
#  define DEBUG DEBUG_BU
#  undef DEBUG_BU
#endif

