#! /usr/bin/env bash

# Wrapper to continue supporting the old `bro-pkg` executable name.
#
# This will print a deprecation warning to stderr if (1) stdin/stdout/stderr
# are all connected to a tty, and (2) the environment variable ZEEK_IS_BRO
# is unset.

function deprecated {
cat >&2 <<EOF
Warning: Use of 'bro-pkg' is deprecated. It is wrapper script that
         will be removed in the future. Please use 'zkg' instead.

EOF
}

test -t 0 && test -t 1 && test -t 2 && test -z "${ZEEK_IS_BRO}" && deprecated

"$(dirname $0)/zkg" "$@"
