/* tosmarking.h
 * Part of ziproxy package.
 *
 * Copyright (c)2009-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Dynamic TOS management
 */

// To stop multiple inclusions.
#ifndef SRC_TOSMARKING_H
#define SRC_TOSMARKING_H

#include "globaldefs.h"

#include "urltables.h"
#include "cttables.h"

extern int tosmarking_init (const int in_tosmarking_enabled, const SOCKET in_sock_child_out, const int in_TOSFlagsDefault, const int in_TOSFlagsDiff, const t_ut_urltable *in_tos_markasdiff_url, const t_ct_cttable *in_tos_maskasdiff_ct, const int in_TOSMarkAsDiffSizeBT);

extern void tosmarking_reset_bytecount ();
extern int tosmarking_add_check_bytecount (const ZP_DATASIZE_TYPE in_bytes);
extern int tosmarking_check_content_type (const char *in_content_type);
extern int tosmarking_check_url (const char *in_host, const char *in_path);

#endif //SRC_TOSMARKING_H

