#import "ExpectationValueTest.h"

@implementation ExpectationValueTest

- (void)testUnsuccessfulExpectation {
    ExpectationValue *expectationValue = [[[ExpectationValue alloc] initWithName:@"My Expectation"] autorelease];
    NSException *exception = nil;

    [expectationValue setExpectedObject:@"Expected"];

    NS_DURING
        [expectationValue verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectation expected Expected, was (null)"];
}

- (void)testSuccessfulExpectation {
    ExpectationValue *expectationValue = [[[ExpectationValue alloc] initWithName:@"My Expectation"] autorelease];

    [expectationValue setExpectedObject:@"Expected"];
    [expectationValue setActualObject:@"Expected"];

    NS_DURING
        [expectationValue verify];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER
}

- (void)testFailImmediatelyOnMismatchingActual {
    ExpectationValue *expectationValue = [[[ExpectationValue alloc] initWithName:@"My Expectation"] autorelease];
    NSException *exception = nil;

    [expectationValue setExpectedObject:@"Expected"];

    NS_DURING
        [expectationValue setActualObject:@"Not Expected"];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception reason] equals:@"My Expectation expected Expected, was Not Expected"];
}

- (void)testFailsOnVerify {
    ExpectationValue *expectationValue = [[[ExpectationValue alloc] initWithName:@"My Expectation"] autorelease];
    NSException *exception = nil;

    [expectationValue setFailsOnVerify:YES];
    
    [expectationValue setExpectedObject:@"Expected"];

    NS_DURING
        [expectationValue setActualObject:@"Not Expected"];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER

    NS_DURING
        [expectationValue verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception reason] equals:@"My Expectation expected Expected, was Not Expected"];
}

- (void)testVerifyPassesOnNoExpectation {
    ExpectationValue *expectationValue = [[[ExpectationValue alloc] initWithName:@"My Expectation"] autorelease];

    NS_DURING
        [expectationValue verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER    
}

- (void)testSetActualPassesOnNoExpectation {
    ExpectationValue *expectationValue = [[[ExpectationValue alloc] initWithName:@"My Expectation"] autorelease];

    NS_DURING
        [expectationValue setActualObject:@"Jeff Bridges"];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

@end
