#import <Foundation/Foundation.h>
#import "UnzipTestCase.h"
#import "ZipArchive.h"
#import "FileInfo.h"
#import "Preferences.h"
#import "MockZipArchive.h"

@implementation UnzipTestCase : ArchiveTestCase

- (void)setUp;
{
	NSDictionary *defaults = [NSDictionary dictionaryWithObjectsAndKeys:
		@"/usr/bin/unzip", PREF_KEY_ZIP, nil];
	[Preferences usePreferences:defaults];
}

- (Archive *)sampleArchive;
{
	NSString *path;
	
    path = [NSBundle pathForResource:@"sample" ofType:@"zip" inDirectory:@"TestResources"];
    [self assertNotNil:path];
    path = [path stringByStandardizingPath];
    return [ZipArchive newWithPath:path];
}

- (void)testSortByRatio
{
	Archive *archive;
	FileInfo *info;
	
	archive = [self sampleArchive];
	[archive sortByRatio];
	info = [archive elementAtIndex:0];
	
	[self assert:[info ratio] equals:@"42%"];
	[self assert:[info filename] equals:@"vacation.rc"];
	
	// sort descending
	[archive sortByRatio];
	info = [archive elementAtIndex:0];
	[self assert:[info ratio] equals:@"78%"];
	[self assert:[info filename] equals:@"junk.rc"];
}

- (void)testMiniUnzOutput
{
	MockZipArchive *archive;
	NSString *path;
	NSArray *elements;
	
	path = [NSBundle pathForResource:@"miniUnz" ofType:@"out"
		inDirectory:@"TestResources"];
	[self assertNotNil:path];
	
	archive = [[[MockZipArchive alloc] initFromFile:path] autorelease];
	elements = [archive elements];
	[self assertInt:[elements count] equals:28];
	[self assert:[[archive elementAtIndex:0] filename] equals:@"after.gif"];
}

@end
