#!/bin/sh

# clean everything
make distclean
(cd Tests; make distclean)

workdir=`pwd`
tempdir=/tmp/zipper-$$
mkdir $tempdir

# make up the filename of the release .tar.gz
release=`cat ZipperInfo.plist | grep ApplicationRelease | awk '{ print $3 }' | tr -d '";'`
releaseName=Zipper-${release}.tar.gz

# insert the correct filename into index.html. Do this before we tar up the whole distro so
# the index.html is correct in distro
cd $workdir/Site
sed -e "s/@@zipper-tar@@/$releaseName/" < template.index.html > index.html

# do not include old distro tarball
cd $workdir
for file in `ls Site/Zipper-*.tar.gz`
do
	rm $file
done

# copy everything to tempdir 
cd ..
tar cf - Zipper | (cd $tempdir; tar xf -)

# remove stuff that's not to be included into distro tarball
cd $tempdir
find . -name CVS -exec rm -r {} \; 2> /dev/null
cd Zipper
rm -r .xvpics .cvsignore .dir.tiff
rm Site/template.index.html
cd ..

# build the tarball
tar czf $releaseName Zipper
mv $releaseName $workdir/Site

# clean up
rm -r $tempdir
