#import <Foundation/Foundation.h>
#import "ZipArchive.h"
#import "FileInfo.h"
#import "NSString+Custom.h"
#import "Preferences.h"
#import "NSArray+Custom.h"

@interface ZipArchive (PrivateAPI)
- (NSData *)dataByRunningUnzip;
@end

@implementation ZipArchive : Archive

+ (NSString *)unarchiveExecutable
{
	return [Preferences zipExecutable];
}

+ (BOOL)hasRatio;
{
	// unzip does provide info about the compression ratio
	return YES;
}

//------------------------------------------------------------------------------
// expanding the archive
//------------------------------------------------------------------------------
- (int)expandFiles:(NSArray *)files withPathInfo:(BOOL)usePathInfo toPath:(NSString *)path
{
	FileInfo *fileInfo;
	NSMutableArray *args;
		
	args = [NSMutableArray array];
	// be really quiet
	[args addObject:@"-qq"];
	// overwrite without warning
	[args addObject:@"-o"];
	if (usePathInfo == NO)
	{
		// junk paths
		[args addObject:@"-j"];
	}
	[args addObject:[self path]];	
	
	if (files != nil)
	{
		NSEnumerator *cursor = [files objectEnumerator];
		while ((fileInfo = [cursor nextObject]) != nil)
		{
			[args addObject:[fileInfo fullPath]];
		}
	}
	
	// destination dir
	[args addObject:@"-d"];
	[args addObject:path];
	return [self runUnarchiverWithArguments:args];
}

- (NSArray *)listContents
{
    NSString *line;
    NSEnumerator *cursor;
    
    NSMutableArray *results = [NSMutableArray array];
    NSData *data = [self dataByRunningUnzip];
    NSString *string = [[[NSString alloc] initWithData:data 
		encoding:NSASCIIStringEncoding] autorelease];
    NSArray *lines = [string componentsSeparatedByString:@"\n"];
    // take out first 3 lines (header) and last 2 lines (footer)
    lines = [lines subarrayWithRange:NSMakeRange(3, [lines count] - 3)];
    lines = [lines subarrayWithRange:NSMakeRange(0, [lines count] - 3)];
    
    cursor = [lines objectEnumerator];
    while ((line = [cursor nextObject]) != nil)
    {
        int length;
        NSString *path, *date, *time, *ratio;
        NSCalendarDate *calendarDate;
        FileInfo *info;
        NSArray *components;
		
		components = [line componentsSeparatedByString:@" "];
		components = [components arrayByRemovingEmptyStrings];

		length = [[components objectAtIndex:0] intValue];
		path = [components objectAtIndex:7];
		ratio = [components objectAtIndex:3];
		
		date = [components objectAtIndex:4];
		time = [components objectAtIndex:5];		
        date = [NSString stringWithFormat:@"%@ %@", date, time];
        calendarDate = [NSCalendarDate dateWithString:date calendarFormat:@"%m-%d-%y %H:%M"];

		// we skip plain directory entries
		if ([path hasSuffix:@"/"] == NO)
		{
			info = [FileInfo newWithPath:path date:calendarDate 
				size:[NSNumber numberWithInt:length] ratio:ratio];
	        [results addObject:info];
		} 
    }
    return results;
}

//------------------------------------------------------------------------------
// private API
//------------------------------------------------------------------------------
- (NSData *)dataByRunningUnzip
{
	NSArray *args = [NSArray arrayWithObjects:@"-lv", [self path], nil];
	return [self dataByRunningUnachiverWithArguments:args];
}

@end
