#!/usr/bin/perl

use File::DesktopEntry 0.03;
use Data::Dumper;
use Encode;

# This script does _not_ use binmode :utf8, the reason for this is that we
# don't want Data::Dumper to escape all utf8. As a consequence we need
# to use Encode before we hand over text to File::DesktopEntry, which
# expects utf8.

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent = 1;

$dir = "share/zim/lingua";
mkdir $dir or die $! unless -e $dir;

for my $file (<po/*.po>) {
	$file =~ /po\/(.*)\.po$/;
	my $lang = $1;
	my $out = "$dir/$lang.pl";
	warn "Compiling $file -> $out\n";

	my ($fuzzy, $empty) = (0, 0);

	# tokenize
	open IN, $file or die $!;
	my @t;
	my $l = 0;
	while (<IN>) {
		$l++;
		$fuzzy++ if /^#,/ and /fuzzy/;
		next if /^#/;
		next if ! /\S/;
		chomp;
		s/\s*$//;
		if (/^(\w+)\s+".*?"$/) {
			s/^(\w+)\s+//;
			die "unknown key '$1' at line $l\n"
				unless grep {$1 eq $_} qw/msgid msgstr/;
			die "unexpected key '$1' at line $l\n"
				if ($#t % 2)
					? ($1 eq 'msgstr')
					: ($1 eq 'msgid')  ;
			push @t, value($_);
		}
		elsif (/^".*?"/) {
			$t[-1] .= value($_);
		}
	}
	close IN;

	# hash tokens
	@t = map {eval "qq#$_#"} @t; # reduce escapes etc. HACK un-save !
	my %t = (@t);

	# some checks
	for my $k (keys %t) {
		unless (length $t{$k}) {
			$empty++;
			next;
		}
		while ($k =~ /(\{\w+\})/g) {
			my $p = $1;
			warn "Translation missing parameter '$p'\n".
			     "msgid: $k\n".
			     "msgstr: $t{$k}\n"
				unless $t{$k} =~ /\Q$p\E/;
		}
	}

	# dump output
	my $meta = delete $t{''};
	$meta =~ s/^/# /gm;
	my $hash = Dumper \%t;
	$hash =~ s/^\$VAR1\s*=\s*/$meta\nuse utf8;\n\n/;
	
	open OUT, '>', $out or die $!;
	print OUT $hash;
	close OUT;

	# update desktop file
	my $df = File::DesktopEntry->new('share/applications/zim.desktop');
	for my $key (qw/Name Comment GenericName/) {
		my $value = $df->get($key.'[C]');
		my $trans = $t{$value};
		$trans = Encode::decode_utf8($trans);
		$df->set("$key\[$lang\]" => $trans) if length $trans;
	}
	$df->write;

	warn "$empty not translated, $fuzzy fuzzy\n" if $empty || $fuzzy;
}

exit;

sub value {
	my $str = shift;
	$str =~ s/^"|"$//g;
	$str =~ s/\\n/\n/g;
	$str =~ s/\\t/\t/g;
	return $str;
}

