#!/usr/bin/perl

use lib './lib';
use Zim::File;

$SIG{__WARN__} = sub { print STDERR @_ unless $_[0] =~ /^#/ };

open IN, 'lib/Zim/GUI.pm' or die $!;
while (<IN>) { last if /CONFIG/ }
while (<IN>) {
	/\{/ and next;
	/\}/ and last;
	chomp;
	($k, $v) = split /\s+/, $_, 2;
	$CONFIG{$k} = $v;
}
close IN;

#use Data::Dumper;
#print Dumper \%CONFIG;

$f = Zim::File->new(qw/share zim default.conf/);
print "Writing $f\n";
$f->write_config(\%CONFIG);

while (<DATA>) {
	if (/^%%\s*(\S+)\s*%%$/) {
		$f = Zim::File->new(qw/share zim/, $1);
		%config = %CONFIG;
		print "Writing $f\n";
	}
	elsif (/^(.+?)=(.*)/) {
		$config{$1} = $2;
	}
	else { $f->write_config(\%config) }
}

__DATA__
%% reader.conf %%
read_only=1

