use File::BaseDir qw/xdg_data_dirs/;
$ENV{XDG_DATA_DIRS} = join ':', 'share', xdg_data_dirs;

my @classes;
my @skip = qw/
	Zim::GUI::TrayIcon
	Zim::GUI::Spell
	Zim::Win32
	Gtk2::Ex::DesktopEntryMenu
/;

open MAN, 'MANIFEST' or die "Could not open MANIFEST\n";
while (<MAN>) {
	chomp;
	next unless /\.pm\b/;
	s#^lib/##;
	s#\.pm\b.*$##;
	s#/#::#g;
	my $c = $_;
	push @classes, $c unless grep {$_ eq $c} @skip;
}
close MAN;

my $t = @skip + @classes + 1;
eval "use Test::More tests => $t\n;";
die $@ if $@;

for (sort @classes) {
	use_ok($_);
}

SKIP: {
	eval "use Gtk2::TrayIcon";
	skip('No Gtk2::TrayIcon available', 1) if $@;
	use_ok('Zim::GUI::TrayIcon');
};

SKIP: {
	eval "use Gtk2::Spell";
	skip('No Gtk2::Spell available', 1) if $@;
	use_ok('Zim::GUI::Spell');
};

SKIP: {
	skip("use Win32 module", 1) unless $^O eq 'MSWin32';
	use_ok('Zim::Win32');
};

SKIP: {
	eval 'use File::MimeInfo::Applications';
	skip('No File::MimeInfo::Applications available', 1) if $@;
	use_ok('Gtk2::Ex::DesktopEntryMenu');
};

TODO: {
	no warnings;
	local $TODO = '? Should work starting gtk+ 2.10';
	use_ok('Gtk2::StatusIcon');
};

