// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

package test.Ice.background;

final class EndpointI extends com.zeroc.IceInternal.EndpointI
{
    final static short TYPE_BASE = 100;

    public EndpointI(Configuration configuration, com.zeroc.IceInternal.EndpointI endpoint)
    {
        _endpoint = endpoint;
        _configuration = configuration;
    }

    @Override
    public String _toString()
    {
        return "test-" + _endpoint.toString();
    }

    @Override
    public com.zeroc.Ice.EndpointInfo getInfo()
    {
        return _endpoint.getInfo();
    }

    @Override
    public void streamWriteImpl(com.zeroc.Ice.OutputStream s)
    {
        s.writeShort(_endpoint.type());
        _endpoint.streamWrite(s);
    }

    @Override
    public short type()
    {
        return (short)(TYPE_BASE + _endpoint.type());
    }

    @Override
    public String protocol()
    {
        return _endpoint.protocol();
    }

    @Override
    public int timeout()
    {
        return _endpoint.timeout();
    }

    @Override
    public com.zeroc.IceInternal.EndpointI timeout(int timeout)
    {
        com.zeroc.IceInternal.EndpointI endpoint = _endpoint.timeout(timeout);
        if(endpoint == _endpoint)
        {
            return this;
        }
        else
        {
            return new EndpointI(_configuration, endpoint);
        }
    }

    @Override
    public String connectionId()
    {
        return _endpoint.connectionId();
    }

    @Override
    public com.zeroc.IceInternal.EndpointI connectionId(String connectionId)
    {
        com.zeroc.IceInternal.EndpointI endpoint = _endpoint.connectionId(connectionId);
        if(endpoint == _endpoint)
        {
            return this;
        }
        else
        {
            return new EndpointI(_configuration, endpoint);
        }
    }

    @Override
    public boolean compress()
    {
        return _endpoint.compress();
    }

    @Override
    public com.zeroc.IceInternal.EndpointI compress(boolean compress)
    {
        com.zeroc.IceInternal.EndpointI endpoint = _endpoint.compress(compress);
        if(endpoint == _endpoint)
        {
            return this;
        }
        else
        {
            return new EndpointI(_configuration, endpoint);
        }
    }

    @Override
    public boolean datagram()
    {
        return _endpoint.datagram();
    }

    @Override
    public boolean secure()
    {
        return _endpoint.secure();
    }

    @Override
    public com.zeroc.IceInternal.Transceiver transceiver()
    {
        com.zeroc.IceInternal.Transceiver transceiver = _endpoint.transceiver();
        if(transceiver != null)
        {
            return new Transceiver(_configuration, transceiver);
        }
        else
        {
            return null;
        }
    }

    @Override
    public void connectors_async(com.zeroc.Ice.EndpointSelectionType selType,
                                 final com.zeroc.IceInternal.EndpointI_connectors cb)
    {
        class Callback implements com.zeroc.IceInternal.EndpointI_connectors
        {
            @Override
            public void connectors(java.util.List<com.zeroc.IceInternal.Connector> cons)
            {
                java.util.List<com.zeroc.IceInternal.Connector> connectors =
                    new java.util.ArrayList<com.zeroc.IceInternal.Connector>();
                for(com.zeroc.IceInternal.Connector p : cons)
                {
                    connectors.add(new Connector(_configuration, p));
                }
                cb.connectors(connectors);
            }

            @Override
            public void exception(com.zeroc.Ice.LocalException exception)
            {
                cb.exception(exception);
            }
        }

        try
        {
            _configuration.checkConnectorsException();
            _endpoint.connectors_async(selType, new Callback());
        }
        catch(com.zeroc.Ice.LocalException ex)
        {
            cb.exception(ex);
        }
    }

    @Override
    public com.zeroc.IceInternal.Acceptor acceptor(String adapterName)
    {
        return new Acceptor(this, _configuration, _endpoint.acceptor(adapterName));
    }

    public EndpointI endpoint(com.zeroc.IceInternal.EndpointI delEndp)
    {
        if(delEndp == _endpoint)
        {
            return this;
        }
        else
        {
            return new EndpointI(_configuration, delEndp);
        }
    }

    @Override
    public java.util.List<com.zeroc.IceInternal.EndpointI> expandIfWildcard()
    {
        java.util.List<com.zeroc.IceInternal.EndpointI> endps = new java.util.ArrayList<>();
        for(com.zeroc.IceInternal.EndpointI endpt : _endpoint.expandIfWildcard())
        {
            endps.add(endpt == _endpoint ? this : new EndpointI(_configuration, endpt));
        }
        return endps;
    }

    @Override
    public com.zeroc.IceInternal.EndpointI.ExpandHostResult expandHost()
    {
        com.zeroc.IceInternal.EndpointI.ExpandHostResult result = _endpoint.expandHost();
        java.util.List<com.zeroc.IceInternal.EndpointI> l = new java.util.ArrayList<>();
        for(com.zeroc.IceInternal.EndpointI e : result.endpoints)
        {
            l.add(e == _endpoint ? this : new EndpointI(_configuration, e));
        }
        result.endpoints = l;
        if(result.publish != null)
        {
            result.publish = result.publish == _endpoint ? this : new EndpointI(_configuration, result.publish);
        }
        return result;
    }

    @Override
    public boolean equivalent(com.zeroc.IceInternal.EndpointI endpoint)
    {
        EndpointI testEndpoint = null;
        try
        {
            testEndpoint = (EndpointI)endpoint;
        }
        catch(ClassCastException ex)
        {
            return false;
        }
        return testEndpoint._endpoint.equivalent(_endpoint);
    }

    @Override
    public String options()
    {
        return _endpoint.options();
    }

    @Override
    public int hashCode()
    {
        return _endpoint.hashCode();
    }

    //
    // Compare endpoints for sorting purposes
    //
    @Override
    public boolean equals(java.lang.Object obj)
    {
        try
        {
            return compareTo((com.zeroc.IceInternal.EndpointI)obj) == 0;
        }
        catch(ClassCastException ee)
        {
            assert(false);
            return false;
        }
    }

    @Override
    public int compareTo(com.zeroc.IceInternal.EndpointI obj) // From java.lang.Comparable
    {
        EndpointI p = null;

        try
        {
            p = (EndpointI)obj;
        }
        catch(ClassCastException ex)
        {
            return type() < obj.type() ? -1 : 1;
        }

        if(this == p)
        {
            return 0;
        }

        return _endpoint.compareTo(p._endpoint);
    }

    public com.zeroc.IceInternal.EndpointI delegate()
    {
        return _endpoint;
    }

    private com.zeroc.IceInternal.EndpointI _endpoint;
    private Configuration _configuration;
}
