/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public class FixedReference
extends Reference {
    private static ConnectionComparator _connectionComparator;
    private ConnectionI[] _fixedConnections;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FixedReference(Instance inst, Communicator com, Identity ident, Map ctx, String fs, int md, ConnectionI[] fixedConns) {
        super(inst, com, ident, ctx, fs, md);
        this._fixedConnections = fixedConns;
    }

    public boolean getSecure() {
        return false;
    }

    public String getAdapterId() {
        return "";
    }

    public EndpointI[] getEndpoints() {
        return new EndpointI[0];
    }

    public boolean getCollocationOptimization() {
        return false;
    }

    public int getLocatorCacheTimeout() {
        return 0;
    }

    public final boolean getCacheConnection() {
        return false;
    }

    public final EndpointSelectionType getEndpointSelection() {
        return EndpointSelectionType.Random;
    }

    public Reference changeSecure(boolean sec) {
        return this;
    }

    public Reference changeRouter(RouterPrx newRouter) {
        return this;
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        return this;
    }

    public Reference changeCollocationOptimization(boolean newCollocationOptimization) {
        return this;
    }

    public Reference changeAdapterId(String newAdapterId) {
        return this;
    }

    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        return this;
    }

    public Reference changeLocatorCacheTimeout(int newTimeout) {
        return this;
    }

    public final Reference changeCacheConnection(boolean newCache) {
        return this;
    }

    public final Reference changeEndpointSelection(EndpointSelectionType newType) {
        return this;
    }

    public Reference changeCompress(boolean newCompress) {
        return this;
    }

    public Reference changeTimeout(int newTimeout) {
        return this;
    }

    public Reference changeConnectionId(String connectionId) {
        return this;
    }

    public void streamWrite(BasicStream s) throws MarshalException {
        throw new MarshalException("Cannot marshal a fixed proxy");
    }

    public String toString() throws MarshalException {
        throw new MarshalException("Cannot marshal a fixed proxy");
    }

    public ConnectionI getConnection(BooleanHolder compress) {
        ConnectionI[] filteredConns = this.filterConnections(this._fixedConnections);
        if (filteredConns.length == 0) {
            NoEndpointException ex = new NoEndpointException();
            ex.proxy = "";
            throw ex;
        }
        ConnectionI connection = filteredConns[0];
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        connection.throwException();
        compress.value = connection.endpoint().compress();
        return connection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedReference)) {
            return false;
        }
        FixedReference rhs = (FixedReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        return Arrays.equals(this._fixedConnections, rhs._fixedConnections);
    }

    private ConnectionI[] filterConnections(ConnectionI[] allConnections) {
        ArrayList<ConnectionI> connections = new ArrayList<ConnectionI>(allConnections.length);
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                int i;
                for (i = 0; i < allConnections.length; ++i) {
                    if (allConnections[i].endpoint().datagram()) continue;
                    connections.add(allConnections[i]);
                }
                break;
            }
            case 3: 
            case 4: {
                int i;
                for (i = 0; i < allConnections.length; ++i) {
                    if (!allConnections[i].endpoint().datagram()) continue;
                    connections.add(allConnections[i]);
                }
                break;
            }
        }
        Collections.shuffle(connections);
        if (this.getSecure()) {
            Iterator i = connections.iterator();
            while (i.hasNext()) {
                ConnectionI connection = (ConnectionI)i.next();
                if (connection.endpoint().secure()) continue;
                i.remove();
            }
        } else {
            Collections.sort(connections, _connectionComparator);
        }
        ConnectionI[] arr = new ConnectionI[connections.size()];
        connections.toArray(arr);
        return arr;
    }

    static {
        $assertionsDisabled = !FixedReference.class.desiredAssertionStatus();
        _connectionComparator = new ConnectionComparator();
    }

    static class ConnectionComparator
    implements Comparator {
        ConnectionComparator() {
        }

        public int compare(Object l, Object r) {
            ConnectionI lc = (ConnectionI)l;
            ConnectionI rc = (ConnectionI)r;
            boolean ls = lc.endpoint().secure();
            boolean rs = rc.endpoint().secure();
            if (ls && rs || !ls && !rs) {
                return 0;
            }
            if (!ls && rs) {
                return -1;
            }
            return 1;
        }
    }
}

