\name{Zelig}

\alias{Zelig}
\alias{blogit}
\alias{bprobit}
\alias{exp}
\alias{gamma}
\alias{logit}
\alias{lognorm}
\alias{ls}
\alias{mlogit}
\alias{mloglm}
\alias{negbin}
\alias{normal}
\alias{ologit}
\alias{oprobit}
\alias{poisson}
\alias{probit}
\alias{relobit}
\alias{weibull}

\title{Zelig: Everyone's Statistical Software}

\description{
  \emph{Zelig} provides a unified notation and framework for statistical
  analysis by encompassing many other statistical methods.  It also
  makes it easy to interpret and present statistical results by
  simulating quantities of interest from their corresponding posterior
  distributions.  Full documentation is available online at
\url{http://gking.harvard.edu/zelig}, and help for specific commands is
available through link{\code{help.zelig}}.}

\details{The following steps are required. First, a model is
  estimated via \code{zelig}. Next, with \code{setx}, the users define
  the values of explanatory variables according to which the quantities
  of interest are simulated. Third, \code{sim} draws quantities of
  interest from their corresponding posterior distributions or their
  asymptotic Normal approximation. Finally, \code{summary} provides a
  useful summaries for the estimated model and simulated quantities of
  interest.  
}

\usage{
z.out <- zelig(formula, model, data, \dots)
x.out <- setx(z.out, \dots)
s.out <- sim(z.out, x = x.out, num = 1000, \dots)
}

\arguments{
  \item{formula}{formula used for a statistical model, using, for example,
    the symbolic representation \code{Y ~ X1 + X2}.  Note that \code{+}
    denotes inclusion, not addition, in the case of the non-linear
    models.}
  \item{model}{name of a statistical model.  Refer to
    \code{help.zelig("models")} for a full list of models. }
  \item{data}{data frame containing variables called in \code{formula}.}
  \item{z.out}{output from \code{zelig}.}
  \item{x.out}{output from \code{setx}.}
  \item{num}{number of simulations, i.e., posterior draws.}
  \item{x}{values of explanatory variables used for simulation.}
  \item{\dots}{additional arguments affecting estimation, values of
    explanatory variables, and simulation.}
}

\value{
  \item{z.out}{output object from \code{zelig}.} 
  \item{x.out}{output object from \code{setx}.}
  \item{s.out}{output object from \code{sim}.}
}

\seealso{Please use link{\code{help.zelig}} to access the Zelig reference
  manual.  The complete document is available online at
  \url{http://gking.harvard.edu/zelig}.  
}

\references{Gary King, Michael Tomz, and Jason Wittenberg (2000),
``Making the Most of Statistical Analyses: Improving Interpretation and
  Presentation,'' \emph{American Journal of Political Science}, vol. 44,
  pp. 347-355.
}

\author{
  Kosuke Imai <\email{kimai@princeton.edu}>; Gary King
  <\email{king@harvard.edu}>; Olivia Lau<\email{olau@fas.harvard.edu}>
}

\keyword{environment}








