zelig <- function(formula, model, data, by = NULL, ...) {
  fn <- paste("zelig2", model, sep = "")
  if (!exists(fn))
    stop("Error:", model, "not supported. Type help.zelig(\"models\") to list supported models.")
  mf <- match.call()
  if (missing(by))
    by <- NULL
  if (!is.null(by)) {
    if (!is.data.frame(data))
      stop("Error: subsetting using 'by' is currently not supported for MI datasets.")  
    temp <- list()
    if (as.character(by) %in% c(formula[[2]], formula[[3]]))
      stop("Error: the variable selected for subsetting cannot be called in the formula.")
    if (as.character(by) %in% names(data)) {
      mf$by <- as.name(by)
      by <- eval(mf$by, data)
      mf$by <- NULL
      lev <- sort(unique(by))
      for (i in 1:length(lev))
        temp[[i]] <- data[by == lev[i],]
      names(temp) <- lev
      data <- temp
    }
  }
  object <- list()
  M <- 1
  if (!is.data.frame(data)) {
    M <- length(data)
    dta <- data
  }
  else
    d <- data
  mf <- do.call(fn, list(formula, model, data, M, ...))
  for (i in 1:M){
    if (M > 1) 
      d <- eval(dta[[i]], sys.parent())
    if (is.data.frame(d)){
      d <- d[complete.cases(model.frame(as.formula(formula), d)),]
      mf$data <- d
      res <- eval(as.call(mf))
      res$call <- match.call()
      res$data <- res$call$data
      res$zelig <- model
      if (M > 1) 
        object[[i]] <- res
      else
        object <- res
    }
    else
      stop(paste("Error:", class(data), "is not a supported data format."))
  }
  if (model == "relogit") {
    if (is.null(object$call$bias.correct))
      object$call$bias.correct <- TRUE
    else
      object$call$bias.correct <- FALSE
    tau <- eval(object$call$tau, sys.parent())
    if (length(tau) == 2) {
      object$lower.estimate$call <- object$upper.estimate$call <- object$call
      object$lower.estimate$call$tau <- round(min(tau),
                                              digits = getOption("digits"))
      object$upper.estimate$call$tau <- round(max(tau),
                                              digits = getOption("digits"))
    }
  }
  if (M > 1)
    if (is.null(by)) 
      class(object) <- "MI"
    else {
      names(object) <- lev
      class(object) <- "multiple"
    }
  object
}
