summary.zelig<-function(object, subset = NULL, CI=95, 
                        stats=c("mean", "sd", "min", "max"), ...){
  cip <- c((100-CI)/200, 1-(100-CI)/200)
  model <- object$zelig.call$model
  summarize <- function(x, cip, stats, model){
    res <- NULL
    if (is.numeric(x)) {
      if (!is.null(stats))
        for (i in 1:length(stats)) 
          res <- cbind(res, apply(x, 2, stats[i]))
      res <- cbind(res, apply(x, 2, quantile, prob=cip[1]))
      res <- cbind(res, apply(x, 2, quantile, prob=cip[2]))
      colnames(res) <- c(stats, paste(cip[1]*100, "%", sep=""),
                         paste(cip[2]*100, "%", sep=""))
    }
    else {
      res <- t(apply(if(is.matrix(x)) x else as.matrix(x), 2, table))
      if (length(unique(x))==1) {
        colnames(res) <- unique(x)
        if(model=="relogit")
          if(colnames(res)==1) {
            res <- cbind(0, res)
            colnames(res)[1] <-0
          }
          else {
            res <- cbind(res, 0)
            colnames(res)[2] <-1
          }
      }
      res <- res/nrow(x) * 100
    }
    return(res)
  }
  qi.stats<-list()
  X <- object$x
  X1 <- object$x1
  if (is.null(dim(X))) {
    X <- matrix(X, ncol = 1)
    colnames(X) <- "(Intercept)"
    if (!is.null(X1)) {
      X1 <- matrix(X1, ncol = 1)
      colnames(X1) <- "(Intercept)"
    }
  }
  for (i in 1:length(object$qi)) {
    qi <- object$qi[[i]]
    if (nrow(X) > 1) {
      if (length(dim(qi)) == 3) {
        if (is.function(subset)){  # subset = all; all is class "function"
          tmp <- summarize(qi[,,1], cip, stats, model)
          tmp <- array(NA, dim=c(nrow(tmp), ncol(tmp), dim(qi)[3]),
                       dimnames=list(dimnames(qi)[[2]], dimnames(tmp)[[2]],
                       rownames(object$x)))
          for (j in 1:dim(qi)[3])
            tmp[,,j] <- summarize(qi[,,j], cip, stats, model)
          qi.stats[[i]] <- tmp
        }
        if(is.null(subset)){# subset = NULL; summarizes all obs at once. 
          tmp <-NULL
          for (j in 1:dim(qi)[3])
            tmp <- rbind(tmp, qi[,,j])
          qi.stats[[i]] <- summarize(tmp, cip, stats, model)
          object$qi.name[[i]] <- paste("Pooled", object$qi.name[[i]])
        }
        if (is.numeric(subset)) { # subset=integer, summarizes identified obs
          k <- dim(qi)[[3]]
          if (subset < k || subset == k) {
            tmp <- summarize(qi[,,1], cip, stats, model)
            tmp <- array(NA, dim=c(nrow(tmp), ncol(tmp), length(subset)),
                         dimnames=list(dimnames(qi)[[2]],
                           dimnames(tmp)[[2]], subset)) 
            for (l in 1:length(subset)){
              tmp[,,l] <- summarize(qi[,,subset[l]], cip, stats, model)
              qi.stats[[i]] <- tmp
              X <- object$x[subset,]
              if (!is.null(object$x1))
              X1 <- object$x1[subset,]
            }
          }
          else 
            print("Error: Selected observation to subset is not in available range of observations.")
        }
      }
      if (length(dim(qi)) == 2) {
        if (is.function(subset)) 
          qi.stats[[i]] <- summarize(qi, cip, stats, model)
        if (is.null(subset)) {
          tmp <- matrix(c(qi), ncol=1)
          tmp <- summarize(tmp, cip, stats, model)
          qi.stats[[i]] <- as.matrix(tmp)
          names(qi.stats[[i]]) <- colnames(tmp)
          object$qi.name[[i]] <- paste("Pooled", object$qi.name[[i]])
        }
        if (is.numeric(subset)) {
          k <- dim(qi)[[2]]
          if (subset < k || subset == k){
            qi.stats[[i]] <- summarize(as.matrix(qi[,subset]), cip,
                                       stats, model)
            X <- X[subset,]
            if(!is.null(object$x1))
              X1 <- X1[subset,]
          }
          else
            print("Error: Selected observation to subset is not in available range of observations.")
        }
      }
    }
    else
      qi.stats[[i]] <- summarize(qi, cip, stats, model)
  }
  names(qi.stats) <- names(object$qi)
  res <- list(zelig=model, num=object$call$num, x=X, x1=X1,
              qi.stats=qi.stats, qi.name=object$qi.name) 
  class(res)<-"summary.zelig"
  res
}




















