sim.MI <- function(object, x, x1 = NULL, num = c(1000, 100), prev =
                   NULL, bootstrap = FALSE, bootfn = NULL, ...){
  M <- length(object)
  simpar <- simqi <- res <- list()
  if (is.null(prev)) {
    if (!bootstrap) {
      if (length(num) == 2)
        num <- num[1]
      numM <- round(num/M)
      for (i in 1:M) 
        simpar[[i]] <- param(object[[i]], num=numM, bootstrap=bootstrap)
    }
    else {
      if (length(num) == 2)
        num <- num[2]
      numM <- round(num/M)
      if (any(class(object[[1]]) == "vglm")) 
        tt <- object[[1]]@terms$terms
      else
        tt <- terms(object[[1]])
      if (missing(bootfn)) {
        bootfn <- function(data, i, object) {
          d <- data[i,]
          object$call$data <- d
          fit <- eval(object$call, sys.parent())
          l1 <- length(param(fit, bootstrap = TRUE))
          l <- length(param(object, bootstrap = TRUE))
          while (l > l1) {
            d1 <- data[sample(nrow(data), replace = TRUE),]
            fit <- update(object, data = d1)
            l1 <- length(param(fit, bootstrap = TRUE))
          }
          return(param(fit, bootstrap = TRUE))
        }
      }
      for (i in 1:M) {
        dta <- eval(object[[i]]$data, sys.parent())
        res <- boot(dta, bootfn, R = num, object = object[[i]],  ...)
        colnames(res$t) <- names(res$t0)
        simpar[[i]] <- res$t
      }
    }
    par <- as.matrix(simpar[[1]])
    for (j in 2:M)
      par <- rbind(par, as.matrix(simpar[[j]]))
  }
  else {
    if (bootstrap)
      stop("Error: Choosing 'bootstrap = TRUE' generates new parameters.  \nIf you wish to use previously generated parameters, \nplease specify only 'prev'.")  
    else
      simpar <- prev
  }
  simqi <- qi(object[[1]], par, x=x, x1=x1)
  c <- match.call()
  c$num <- num
  res <- list(x=x, x1=x1, call = c, zelig.call = object[[1]]$call, 
              par = simpar, qi=simqi$qi, qi.name = simqi$qi.name)
  class(res) <- "zelig"
  res
}







