setx.multiple <- function(object, data = NULL, cond = FALSE, ...){
  dta <- eval(object[[1]]$call$data, sys.parent())
  d <- x <- list()
  by <- object[[1]]$call$by
  idx <- pmatch(by, names(dta))[1]
  lev <- sort(unique(eval(dta[[idx]], sys.parent())))
  if (cond) {
    for (i in 1:length(lev)) {
      d[[i]] <- as.data.frame(dta[dta[[idx]] == lev[i],])
      x[[i]] <- setx.default(object[[i]], data = d[[i]], cond = cond, ...)
      class(x[[i]]) <- "setx.cond"
    }
  }
  else {
    x <- setx.default(object[[1]], data = data, cond = cond, ...)
    class(x) <- "setx"
  }
  x 
}




