print.relogit <- function(object, digits = getOption("digits"), ...) {
  if (names(object)$default[1] == "lower.estimate") {
    cat(paste("\nEstimate for tau =",
              round(object$lower.estimate$call$tau, digits = 5), "\n"))
    print.glm(object$lower.estimate, digits = digits, ...)
    cat(paste("\n\nEstimate for tau =",
              round(object$upper.estimate$call$tau, digits = 5), "\n"))    
    print.glm(object$upper.estimate, digits = digits, ...)
  }
  else
    print.glm(object, digits  = digits, ...)
}
