model.start <- function(e, m) {
  start <- m$start
  m$start <- m$... <- NULL
  m[[1]] <- as.name("model.frame")
  mf <- eval.parent(m)
  assign("mf", mf, envir = e)
  Terms <- attr(mf, "terms")
  assign("Terms", Terms, envir = e)
  x <- model.matrix(Terms, mf)
  assign("x", x, envir = e)
  yvar <- attr(Terms, "response")
  xvars <- as.character(attr(Terms, "response"))[-1]
  xlev <- if (length(xvars) > 0) {
    xlev <- lapply(mf[xvars], levels)
    xlev[!sapply(xlev, is.null)]
  }
  assign("xlev", xlev, envir = e)
  y <- model.response(mf)
  assign("y", y, envir = e)
  lev <- levels(y)
  assign("lev", lev, envir = e)
  if (is.null(start))
    start <- lm(y ~ x -1)$coef
  assign("start", start, envir = e)
}
