model.end <- function(e, res) {
  variance <- -solve(res$hessian)
  lev <- eval(as.name("lev"), envir = e)
  Terms <- eval(as.name("Terms"), envir = e)
  call <- eval(as.name("m"), envir = e)   
  xlev <- eval(as.name("xlev"), envir = e)
  mf <- eval(as.name("mf"), envir = e)
  names(res$par) <- c("(Intercept)", attr(Terms, "term.labels"))
  colnames(variance) <- rownames(variance) <- names(res$par)
  fit <- list(coefficients = res$par, variance = variance, 
              lev = lev, terms = Terms, call = call, 
              convergence = res$convergence, xlevels = xlev) 
  attr(fit, "na.message") <- attr(mf, "na.message") 
  if (!is.null(attr(mf, "na.action"))) 
    fit$na.action <- attr(mf, "na.action") 
  fit
}
