cmvglm<-function(formula, model, equal, zeros, ones, ndim){ 
  tt<-terms(formula)
  vars<-c("(Intercept)", attr(tt, "term.labels"))
  cm<-vector("list", length(vars))
  names(cm)<-vars
    for(i in 1:length(cm))
      cm[[i]]<-diag(1, ndim)
  if(!is.null(equal)){
    cnames<-names(equal)
    for(i in 1:length(equal)){
      ci<-sort(unique(equal[[i]]))
      indx<-pmatch(cnames[i], names(cm))
      for(j in 1:length(ci)){
        cm[[indx]][ci[j],ci[j]]<-0
        cm[[indx]][ci[j],ci[1]]<-1
      }
    }
  }
  if(!is.null(zeros)){
    cnames<-names(zeros)
    for(i in 1:length(zeros)){
      ci<-sort(unique(zeros[[i]]))
      indx<-pmatch(cnames[i], names(cm))
      for(j in 1:length(ci))
        cm[[indx]][ci[j],ci[j]]<-0
    }
  }
  if(!is.null(ones))
    for(i in 1:length(ones))
      for(j in 1:length(cm))
        if(names(cm)[j]!="(Intercept)")
          cm[[j]][ones[i],]<-matrix(0, ncol=ncol(cm[[j]]))
  for(i in 1:length(cm))
    cm[[i]]<-as.matrix(cm[[i]][,apply(cm[[i]], 2, sum)!=0])
  list("formula"=formula, "constraints"=cm)
}
