#ifndef	ZAP_DEBUG_H
#define	ZAP_DEBUG_H

#define	DBG(fmt, ...)	\
	((print_dbg) && printk(KERN_DEBUG "DBG-%s: %s: " fmt, \
		THIS_MODULE->name, __FUNCTION__, ## __VA_ARGS__))
#define	INFO(fmt, ...)	printk(KERN_INFO "INFO-%s: " fmt, THIS_MODULE->name, ## __VA_ARGS__)
#define	NOTICE(fmt, ...)	printk(KERN_NOTICE "NOTICE-%s: " fmt, THIS_MODULE->name, ## __VA_ARGS__)
#define	ERR(fmt, ...)	printk(KERN_ERR "ERR-%s: " fmt, THIS_MODULE->name, ## __VA_ARGS__)


void dump_poll(int print_dbg, const char *msg, int poll);
char *event2str(int event);
void dump_sigtype(int print_dbg, const char *msg, int sigtype);

#endif	/* ZAP_DEBUG_H */
