#ifndef	XPP_ZAP_H
#define	XPP_ZAP_H

#include <linux/workqueue.h>
#include "xpd.h"
#include "xproto.h"

xpacket_t *xpacket_new(xbus_t *xbus, int flags);
void xpacket_free(xbus_t *xbus, xpacket_t *p);

/* packet queues */
void init_xbus_packet_queue(packet_queue_t *q, const char name[]);
void drain_xbus_packet_queue(xbus_t *xbus, packet_queue_t *q);
void xbus_enqueue_packet(xbus_t *xbus, packet_queue_t *q, xpacket_t *pack);
xpacket_t *xbus_dequeue_packet(packet_queue_t *q);

xbus_t *xbus_new(ulong loopback_xpds);
void xbus_activate(xbus_t *xbus);
void xbus_deactivate(xbus_t *xbus);

void xbus_reset_counters(xbus_t *xbus);
int packet_send(xbus_t *xbus, xpacket_t *pack_tx);
void phone_hook(xpd_t *xpd, int channo, bool offhook);
void xpp_check_hookstate(xpd_t *xpd, xpp_line_t fxs_off_hook);
xpd_t *xpd_of(xbus_t *xbus, int xpd_num);
void card_detected(void *data);
xpd_t *xpd_alloc(size_t privsize, xbus_t *xbus, int xpd_num, const xproto_table_t *proto_table, int channels, byte revision);
void xpd_remove(xpd_t *xpd);
void fill_beep(u_char *buf, int duration);
void xpp_tick(unsigned long param);
int xpp_open(struct zt_chan *chan);
int xpp_close(struct zt_chan *chan);
int xpp_ioctl(struct zt_chan *chan, unsigned int cmd, unsigned long arg);
int xpp_maint(struct zt_span *span, int cmd);

#define	CARD_DESC_MAGIC	0xca9dde5c

struct	card_desc_struct {
	struct work_struct	work;
	u32			magic;
	xbus_t			*xbus;
	byte			rev;		/* Revision number */
	byte			type;		/* LSB: 1 - to_phone, 0 - to_line */
	byte			xpd_num;
};
extern struct workqueue_struct		*xpp_worker;

#ifdef CONFIG_PROC_FS
#include <linux/proc_fs.h>

extern struct proc_dir_entry	*xpp_procdir;
#endif
extern xpd_t			*sync_master;

// Number of rings our simulated phone will ring:
#define RINGS_NUM 3

#endif	/* XPP_ZAP_H */
