package Zaptel::Chans;
#
# Written by Oron Peled <oron@actcom.co.il>
# Copyright (C) 2007, Xorcom
# This program is free software; you can redistribute and/or
# modify it under the same terms as Perl itself.
#
#use strict;

# Accessors (miniperl does not have Class:Accessor)
sub AUTOLOAD {
	my $self = shift;
	my $name = uc($AUTOLOAD);
	$name =~ s/.*://;   # strip fully-qualified portion
	if (@_) {
		return $self->{$name} = shift;
	} else {
		return $self->{$name};
	}
}

sub new($$$$$) {
	my $pack = shift or die "Wasn't called as a class method\n";
	my $span = shift or die "Missing a span parameter\n";
	my $num = shift or die "Missing a channel number parameter\n";
	my $fqn = shift or die "Missing a channel fqn parameter\n";
	my $info = shift;
	my $self = {};
	bless $self, $pack;
	$self->span($span);
	$self->num($num);
	$self->fqn($fqn);
	$self->info($info);
	my $type;
	if($fqn =~ m|\bXPP_(\w+)/.*$|) {
		$type = $1;		# One of our AB
	} elsif(defined $info) {
		$type = (split(/\s+/, $info))[0];
	} else {
		$type = $fqn;
	}
	$self->type($type);
	return $self;
}

1;
