
# Aranet Cloud

## Overview

For Zabbix version: 6.0 and higher  

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/6.0/manual/config/templates_out_of_the_box/http) for basic instructions.

Refer to the vendor documentation.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ARANET.API.ENDPOINT} |<p>Aranet Cloud API endpoint.</p> |`https://aranet.cloud/api` |
|{$ARANET.API.PASSWORD} |<p>Aranet Cloud password.</p> |`<PUT YOUR PASSWORD>` |
|{$ARANET.API.SPACE_NAME} |<p>Aranet Cloud organization name.</p> |`<PUT YOUR SPACE NAME>` |
|{$ARANET.API.USERNAME} |<p>Aranet Cloud username.</p> |`<PUT YOUR USERNAME>` |
|{$ARANET.BATT.VOLTAGE.MIN.CRIT} |<p>Battery voltage critical threshold.</p> |`2` |
|{$ARANET.BATT.VOLTAGE.MIN.WARN} |<p>Battery voltage warning threshold.</p> |`1` |
|{$ARANET.CO2.MAX.CRIT} |<p>CO2 critical threshold.</p> |`1000` |
|{$ARANET.CO2.MAX.WARN} |<p>CO2 warning threshold.</p> |`600` |
|{$ARANET.HUMIDITY.MAX.WARN} |<p>Maximum humidity threshold.</p> |`70` |
|{$ARANET.HUMIDITY.MIN.WARN} |<p>Minimum humidity threshold.</p> |`20` |
|{$ARANET.LAST_UPDATE.MAX.WARN} |<p>Data update delay threshold.</p> |`1h` |
|{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES} |<p>Filter of discoverable sensors by gateway id.</p> |`.+` |
|{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES} |<p>Filter of discoverable sensors by gateway name.</p> |`.+` |
|{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES} |<p>Filter to exclude discoverable sensors by gateway name.</p> |`CHANGE_IF_NEEDED` |
|{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES} |<p>Filter of discoverable sensors by id.</p> |`.+` |
|{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES} |<p>Filter of discoverable sensors by name.</p> |`.+` |
|{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES} |<p>Filter to exclude discoverable sensors by name.</p> |`CHANGE_IF_NEEDED` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Atmospheric pressure discovery |<p>Discovery for Aranet Cloud atmospheric pressure sensors</p> |DEPENDENT |aranet.pressure.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Atmospheric Pressure`</p> |
|Battery voltage discovery |<p>Discovery for Aranet Cloud Battery voltage sensors</p> |DEPENDENT |aranet.battery.voltage.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Battery voltage`</p> |
|CO2 discovery |<p>Discovery for Aranet Cloud CO2 sensors</p> |DEPENDENT |aranet.co2.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `CO₂`</p> |
|Current discovery |<p>Discovery for Aranet Cloud Current sensors</p> |DEPENDENT |aranet.current.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Current`</p> |
|Differential Pressure discovery |<p>Discovery for Aranet Cloud Differential Pressure sensors</p> |DEPENDENT |aranet.diff_pressure.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Differential Pressure`</p> |
|Distance discovery |<p>Discovery for Aranet Cloud Distance sensors</p> |DEPENDENT |aranet.distance.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Distance`</p> |
|Humidity discovery |<p>Discovery for Aranet Cloud humidity sensors</p> |DEPENDENT |aranet.humidity.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Humidity`</p> |
|Illuminance discovery |<p>Discovery for Aranet Cloud Illuminance sensors</p> |DEPENDENT |aranet.illuminance.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Illuminance`</p> |
|Last update discovery |<p>Discovery for Aranet Cloud Last update metric</p> |DEPENDENT |aranet.last_update.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Last update`</p> |
|pH discovery |<p>Discovery for Aranet Cloud pH sensors</p> |DEPENDENT |aranet.ph.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `pH`</p> |
|Pore Electrical Conductivity discovery |<p>Discovery for Aranet Cloud Pore Electrical Conductivity sensors</p> |DEPENDENT |aranet.pore_electric_cond.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Pore Electrical Conductivity`</p> |
|PPFD discovery |<p>Discovery for Aranet Cloud PPFD sensors</p> |DEPENDENT |aranet.ppfd.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `PPFD`</p> |
|Pulses Cumulative discovery |<p>Discovery for Aranet Cloud Pulses Cumulative sensors</p> |DEPENDENT |aranet.pulses_cumulative.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Pulses Cumulative`</p> |
|Pulses discovery |<p>Discovery for Aranet Cloud Pulses sensors</p> |DEPENDENT |aranet.pulses.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Pulses`</p> |
|RSSI discovery |<p>Discovery for Aranet Cloud RSSI sensors</p> |DEPENDENT |aranet.rssi.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `RSSI`</p> |
|Soil Dielectric Permittivity discovery |<p>Discovery for Aranet Cloud Soil Dielectric Permittivity sensors</p> |DEPENDENT |aranet.soil_dielectric_perm.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Soil Dielectric Permittivity`</p> |
|Soil Electrical Conductivity discovery |<p>Discovery for Aranet Cloud Soil Electrical Conductivity sensors</p> |DEPENDENT |aranet.soil_electric_cond.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Soil Electrical Conductivity`</p> |
|Temperature discovery |<p>Discovery for Aranet Cloud temperature sensors</p> |DEPENDENT |aranet.temp.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Temperature`</p> |
|Voltage discovery |<p>Discovery for Aranet Cloud Voltage sensors</p> |DEPENDENT |aranet.voltage.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Voltage`</p> |
|Volumetric Water Content discovery |<p>Discovery for Aranet Cloud Volumetric Water Content sensors</p> |DEPENDENT |aranet.volum_water_content.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Volumetric Water Content`</p> |
|Weight discovery |<p>Discovery for Aranet Cloud Weight sensors</p> |DEPENDENT |aranet.weight.discovery<p>**Filter**:</p>AND <p>- {#SENSOR_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.MATCHES}`</p><p>- {#SENSOR_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_NAME.NOT_MATCHES}`</p><p>- {#SENSOR_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.SENSOR_ID.MATCHES}`</p><p>- {#GATEWAY_NAME} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.MATCHES}`</p><p>- {#GATEWAY_NAME} NOT_MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_NAME.NOT_MATCHES}`</p><p>- {#GATEWAY_ID} MATCHES_REGEX `{$ARANET.LLD.FILTER.GATEWAY_ID.MATCHES}`</p><p>- {#METRIC} MATCHES_REGEX `Weight`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.temp["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.humidity["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.rssi["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.battery.voltage["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.co2["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.pressure["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.voltage["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.weight["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.volumetric.water.content["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.ppfd["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.distance["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.illuminance["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.ph["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.current["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.soil_dielectric_perm["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.soil_electric_cond["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.pore_electric_cond["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.pulses["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.pulses_cumulative["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.diff_pressure["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p> |
|Aranet |{#METRIC}: [{#GATEWAY_NAME}] {#SENSOR_NAME} |<p>-</p> |DEPENDENT |aranet.last_update["{#GATEWAY_ID}", "{#SENSOR_ID}"]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id == "{#SENSOR_ID}" && @.name == "{#SENSOR_NAME}")].metrics[?(@.name == "{#METRIC}")].value.first()`</p><p>- JAVASCRIPT: `return Math.floor(Date.now()/1000 - Number(value));`</p> |
|Zabbix raw items |Aranet: Sensors discovery |<p>Discovery for Aranet Cloud sensors</p> |DEPENDENT |aranet.sensor.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `15m`</p> |
|Zabbix raw items |Aranet: Get data |<p>-</p> |SCRIPT |aranet.get_data<p>**Expression**:</p>`The text is too long. Please see the template.` |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|{#METRIC}: Low humidity on "[{#GATEWAY_NAME}] {#SENSOR_NAME}" | |`max(/Aranet Cloud/aranet.humidity["{#GATEWAY_ID}", "{#SENSOR_ID}"],5m) < {$ARANET.HUMIDITY.MIN.WARN:"{#SENSOR_NAME}"}` |WARNING |<p>**Depends on**:</p><p>- {#METRIC}: High humidity on "[{#GATEWAY_NAME}] {#SENSOR_NAME}"</p> |
|{#METRIC}: High humidity on "[{#GATEWAY_NAME}] {#SENSOR_NAME}" | |`min(/Aranet Cloud/aranet.humidity["{#GATEWAY_ID}", "{#SENSOR_ID}"],5m) > {$ARANET.HUMIDITY.MAX.WARN:"{#SENSOR_NAME}"}` |HIGH | |
|{#METRIC}: Low battery voltage on "[{#GATEWAY_NAME}] {#SENSOR_NAME}" |<p>-</p> |`max(/Aranet Cloud/aranet.battery.voltage["{#GATEWAY_ID}", "{#SENSOR_ID}"],5m) < {$ARANET.BATT.VOLTAGE.MIN.WARN:"{#SENSOR_NAME}"}` |WARNING |<p>**Depends on**:</p><p>- {#METRIC}: Critically low battery voltage on "[{#GATEWAY_NAME}] {#SENSOR_NAME}"</p> |
|{#METRIC}: Critically low battery voltage on "[{#GATEWAY_NAME}] {#SENSOR_NAME}" |<p>-</p> |`max(/Aranet Cloud/aranet.battery.voltage["{#GATEWAY_ID}", "{#SENSOR_ID}"],5m) < {$ARANET.BATT.VOLTAGE.MIN.CRIT:"{#SENSOR_NAME}"}` |HIGH | |
|{#METRIC}: High CO2 level on "[{#GATEWAY_NAME}] {#SENSOR_NAME}" |<p>-</p> |`min(/Aranet Cloud/aranet.co2["{#GATEWAY_ID}", "{#SENSOR_ID}"],5m) > {$ARANET.CO2.MAX.WARN:"{#SENSOR_NAME}"}` |WARNING |<p>**Depends on**:</p><p>- {#METRIC}: Critically high CO2 level on "[{#GATEWAY_NAME}] {#SENSOR_NAME}"</p> |
|{#METRIC}: Critically high CO2 level on "[{#GATEWAY_NAME}] {#SENSOR_NAME}" |<p>-</p> |`min(/Aranet Cloud/aranet.co2["{#GATEWAY_ID}", "{#SENSOR_ID}"],5m) > {$ARANET.CO2.MAX.CRIT:"{#SENSOR_NAME}"}` |HIGH | |
|{#METRIC}: Sensor data "[{#GATEWAY_NAME}] {#SENSOR_NAME}" is not updated |<p>-</p> |`last(/Aranet Cloud/aranet.last_update["{#GATEWAY_ID}", "{#SENSOR_ID}"]) > {$ARANET.LAST_UPDATE.MAX.WARN:"{#SENSOR_NAME}"}` |WARNING | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

