#!/usr/bin/perl -w 

%consonants = (
	"k" => "0x0c15",
	"kh" => "0x0c16",
	"g" => "0x0c17",
	"gh" => "0x0c18",
	"N^" => "0x0c19",
	"~N" => "0x0c19",
	"c" => "0x0c1a",
	"ch" => "0x0c1a",
	"chh" => "0x0c1b",
	"Ch" => "0x0c1b",
	"j" => "0x0c1c",
	"jh" => "0x0c1d",
	"~n" => "0x0c1e",
	"JN" => "0x0c1e",
	"T" => "0x0c1f",
	"Th" => "0x0c20",
	"D" => "0x0c21",
	"Dh" => "0x0c22",
	"N" => "0x0c23",
	"t" => "0x0c24",
	"th" => "0x0c25",
	"d" => "0x0c26",
	"dh" => "0x0c27",
	"n" => "0x0c28",
	"p" => "0x0c2a",
	"ph" => "0x0c2b",
	"b" => "0x0c2c",
	"bh" => "0x0c2d",
	"m" => "0x0c2e",
	"y" => "0x0c2f",
	"r" => "0x0c30",
	"R" => "0x0c31",
	"l" => "0x0c32",
	"L" => "0x0c33",
	"v" => "0x0c35",
	"w" => "0x0c35",
	"sh" => "0x0c36",
	"shh" => "0x0c37",
	"Sh" => "0x0c37",
	"s" => "0x0c38",
	"h" => "0x0c39",
	"x" => "0x0c15 0x0c4d 0x0c37",
	"GY" => "0x0c1c 0x0c4d 0x0c1e",
	"dny" => "0x0c1c 0x0c4d 0x0c1e",
);

%vowels = (
	"" => " 0x0c4d",
	"a" => "",
	"A" => " 0x0c3e",
	"aa" => " 0x0c3e",
	"i" => " 0x0c3f",
	"I" => " 0x0c40",
	"ii" => " 0x0c40",
	"u" => " 0x0c41",
	"U" => " 0x0c42",
	"uu" => " 0x0c42",
	"R^i" => " 0x0c43",
	"RRi" => " 0x0c43",
	"R^I" => " 0x0c44",
	"RRI" => " 0x0c44",
	"e" => " 0x0c46",
	"E" => " 0x0c47",
	"ai" => " 0x0c48",
	"o" => " 0x0c4a",
	"O" => " 0x0c4b",
	"au" => " 0x0c4c",
	".h" => " 0x0c4d 0x200c",
);

print "// Telugu kmap according to Itrans transliteration\n";
print "// by Miikka-Markus Alhonen 2002-02-17\n\n";
print "// Consonant + vowel/virama\n";

foreach $cons (sort keys %consonants) {
  foreach $vowel (sort keys %vowels) {
    printf ("\"%s%s=%s%s\",\n",$cons,$vowel,$consonants{$cons},$vowels{$vowel});
  }
}

print <<EOF;

// Independent vowels

"a=0x0c05",
"A=0x0c06",
"aa=0x0c06",
"i=0x0c07",
"I=0x0c08",
"ii=0x0c08",
"u=0x0c09",
"U=0x0c0a",
"uu=0x0c0a",
"R^i=0x0c0b",
"RRi=0x0c0b",
"L^i=0x0c0c",
"LLi=0x0c0c",
"e=0x0c0e",
"E=0x0c0f",
"ai=0x0c10",
"o=0x0c12",
"O=0x0c13",
"au=0x0c14",
"R^I=0x0c60",
"RRI=0x0c60",
"L^I=0x0c61",
"LLI=0x0c61",

// Numbers

"0x30=0x0c66",
"0x31=0x0c67",
"0x32=0x0c68",
"0x33=0x0c69",
"0x34=0x0c6a",
"0x35=0x0c6b",
"0x36=0x0c6c",
"0x37=0x0c6d",
"0x38=0x0c6e",
"0x39=0x0c6f",

// Other marks

".N=0x0c01",
".n=0x0c02",
"M=0x0c02",
"H=0x0c03",
".h=0x0c4d 0x200c",
".=0x0964",
"..=0x0965",
"|=0x0964",
"||=0x0965",
";=0x0965",
"{\\\\rm 0x20 .}=0x002e",
"{}=0x200d",
EOF
