/*	$Id: YSM.h,v 1.140 2004/07/10 17:28:14 rad2k Exp $	*/
/*
-======================== ysmICQ client ============================-
		Having fun with a boring Protocol
-============================ YSM.h ================================-

YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include "YSM_Config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>

#ifdef OS2
#include "YSM_os2.h"
#endif

#ifdef WIN32
#include <conio.h>
#include <winsock.h>
#include <sys/timeb.h>
#include <sys/stat.h>
#include <windows.h>
#include <mmsystem.h>
#else
#include <unistd.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <signal.h>
#include <termios.h>
#include <unistd.h>
#endif

#if defined(BEOS) || defined(OS2)
#include <sys/select.h>
#endif

/* multi-languages support + cryptography */
#include "YSM_Lang.h"
#include "rijndael/rijndael-api-fst.h"

/* Charset compatbility */
#ifdef WIN32
#define YSM_USE_CHARCONV
#endif

/* Threads compatibility */
#ifdef WIN32
#define YSM_WITH_THREADS
#endif

#define THREADS_COUNT	0x3

#if defined(YSM_WITH_THREADS)
#if !defined(WIN32) && (!defined(OS2))
#include <pthread.h>
#endif
#endif

#ifdef WIN32
#define putch		_putch
#define	close		closesocket
#define snprintf	_snprintf
#define strcasecmp	_stricmp
#define strncasecmp	_strnicmp
#endif

/* used in *nix systems lacking posix data types */
#ifdef MISSING_SIGNED	
typedef signed char	int8_t;
typedef signed short	int16_t;
typedef signed int	int32_t;
#endif
#ifdef MISSING_UNSIGNED
typedef	unsigned char	u_int8_t;
typedef unsigned short	u_int16_t;
typedef unsigned int	u_int32_t;
#endif

#ifdef WIN32
typedef signed char	int8_t;
typedef	unsigned char	u_int8_t;
typedef signed short	int16_t;
typedef unsigned short	u_int16_t;
typedef signed int	int32_t;
typedef unsigned int	u_int32_t;
#else
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif

#ifndef __RCSID
#define __RCSID(x)
#endif

#define YSM_MSG_KIND_ONELINE 0
#define YSM_MSG_KIND_VERBOSE 1
#define YSM_MSG_KIND_IRC 2

#define YSM_DEFAULT_MSG_KIND	YSM_MSG_KIND_IRC

#if !defined (WIN32) && !defined (TRUE)
#define FALSE 0
#define TRUE !FALSE 
#endif

#ifdef WIN32
#define SOCK_READ(x,y,z) recv(x,y,z,0)
#define SOCK_WRITE(x,y,z) send(x,y,z,0)
#else
#define SOCK_READ(x,y,z) read(x,y,z)
#define SOCK_WRITE(x,y,z) write(x,y,z)
#endif

/* Definition of User Config Parameters */

#define YSM_INFORMATION		"ysmICQ - Peace, Love & Dreams - "  
#define YSM_INFORMATION2	"2.9.6"

#ifdef WIN32
#define YSM_CFGDIRECTORY	"ysm"
#define YSM_PROXYKEY		"Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings"
#define YSM_PROXYVALUE		"ProxyServer"
#else
#define YSM_CFGDIRECTORY	".ysm"
#endif
#define YSM_CFGFILENAME		"ysm-cfg"
#define YSM_INCOMINGDIRECTORY	"incoming"
#define YSM_SOUNDSDIRECTORY	"sounds"
#define YSM_DEFAULTSRV		"login.icq.com"
#define YSM_DEFAULTPORT		5190
#define YSM_KEEPALIVETIME	90
#define YSM_COMMANDSTIME	15

#ifndef WIN32
#define MAX_PATH		256
#endif

#define MAX_SEQS_FILED		50
#define MAX_DATA_LEN		2547
#define MAX_MSGDATA_LEN		MAX_DATA_LEN
#define MAX_PEER_DATA_SIZE	2050
#define MAX_PEER_FILENAMEL	50
#define MAX_CRYPT_PADDING	16
#define MAX_PWD_LEN		12
#define MAX_NICK_LEN		30
#define MAX_UIN_LEN		14
#define MAX_CMD_NAME		15
#define MAX_CMD_ARGS		MAX_DATA_LEN+2
#define	MAX_EXEC_ARGS		50
#define MAX_CMD_LEN		MAX_DATA_LEN
#define MAX_CMD_HIST		15
#define MAX_LINE_LEN		80
#define MAX_LOGSEP_LEN		5
#define MAX_STATUS_LEN		50
#define MAX_CONTACTS_SEND	15
#define MAX_CHARSET		10
#define MAX_SAVE_COUNT		5
#define MAX_SCAN_COUNT		2
#define MAX_TIME_LEN		21	/* dd mmm yyyy hh:mm:ss + NUL */
#define MAX_SLAVELIST_LEN	8192

/* Required for log files parsing watch out for MAX_LOGSEP_LEN  */
#define YSM_LOG_SEPARATOR	"$YSM$"

#define YSM_VERSIONCHECK_HOST	"ysmv7.sourceforge.net"
#define YSM_VERSIONCHECK_FILE	"lastversion.dat"

/* AFK definitions */
#define YSM_AFKFILENAME		"afk-log"
#define YSM_AFK_MESSAGE		"I'm AFK (away from keyboard) right now. \
Your message has been saved. I'll be back shortly! :)"
/* Seconds to wait before re-sending an afk message (skip flooding) */
#define MINIMUM_AFK_WAIT	30

/* CHAT! */
#define YSM_CHAT_MESSAGE	"I'm busy in a conversation. Your message has been logged. I'll get back to you ASAP."

/* Authorization Request definitions */

#define YSM_DEFAULT_AUTHREQ_MESSAGE	"Hi. I require your authorization in order to add you to my contacts list."

/* End of Config Parameters */

/* YSM Buddy List Group */
#define YSM_BUDDY_GROUPNAME	"YSM"
#define YSM_BUDDY_GROUPID	0x1337

#define YSM_BUDDY_SLAVE		0x0000
#define YSM_BUDDY_SLAVE_VIS	0x0002
#define YSM_BUDDY_SLAVE_INV	0x0003
#define YSM_BUDDY_SLAVE_IGN	0x000e


#define YSM_BUDDY_GROUP		0x0001

/* ok! */


/* Debug Level Definitions! */

#define VERBOSE_BASE		0
#define VERBOSE_STCHANGE	1
#define VERBOSE_CONNINFO	2
#define VERBOSE_DCON		20
#define VERBOSE_MOREDATA	21
#define VERBOSE_PACKET		22
#define VERBOSE_SDOWNLOAD	23

/* finishes here */

/* Start of Client Fingerprint32_ting Definitions */

#define FINGERPRINT_YSM_CLIENT			0xabffffff
#define FINGERPRINT_YSM_CLIENT_CRYPT		0xdeadbabe
#define FINGERPRINT_TRILLIAN_CLIENT		0x3b75ac09
#define FINGERPRINT_LIB2K_CLIENT		0x3aa773ee
#define FINGERPRINT_MICQ2003A_CLIENT_1		0x3CF02D22
#define FINGERPRINT_MICQ2003A_CLIENT_2		0x3E76502C
#define FINGERPRINT_LICQ_CLIENT			0x7d000000
#define FINGERPRINT_MICQ_CLIENT			0xffffff42
#define FINGERPRINT_MIRANDA_CLIENT		0xffffffff
#define FINGERPRINT_STRICQ_CLIENT		0xffffff8f

/* the following clients are identified by capabilities */
#define FINGERPRINT_SIMICQ_CLIENT		0x04040404
#define FINGERPRINT_M2000_CLIENT		0x06060606
#define FINGERPRINT_M20012_CLIENT		0x07070707
#define FINGERPRINT_M2002_CLIENT		0x08080808
#define FINGERPRINT_MICQLITE_CLIENT		0x09090909 
#define FINGERPRINT_ICQ2GO_CLIENT		0x0a0a0a0a
#define FINGERPRINT_MISC_CLIENT			0x00

#define SLAVES_TAG	"SLAVES"

#define NUM_ELEM_ARR(arr)	(sizeof((arr))/sizeof((arr)[0]))

#define STATUS_ONLINE		0x0000
#define STATUS_OFFLINE		0xffff
#define STATUS_INVISIBLE	0x0100
#define STATUS_NA		0x0005
#define STATUS_NA2		0x0004
#define STATUS_DND		0x0013
#define STATUS_OCCUPIED		0x0011
#define STATUS_FREE_CHAT	0x0020
#define STATUS_AWAY		0x0001
#define STATUS_AFK		0xfed0
#define	STATUS_UNKNOWN		0xdead

#define STATUS_FLWEBAWARE	0x0001
#define STATUS_FLIPSHOW		0x0002
#define STATUS_FLBIRTHDAY	0x0008
#define STATUS_FLDC_AUTH	0x1000
#define STATUS_FLDC_CONT	0x2000

/* Definition of Queries */

#define SLAVE_NAME		0x01
#define SLAVE_UIN		0x02
#define SLAVE_REQID		0x03

#define INFO_MAIN		0x01
#define INFO_HP			0x02
#define INFO_WORK		0x03
#define INFO_ABOUT		0x04

#define UPDATE_SLAVE		0x00
#define UPDATE_NICK		0x01

#define YSM_INFO_NICK		0x00
#define YSM_INFO_EMAIL		0x01

/* End of Slave Queries	*/


/* Definition of Message Types for Displaying functions */

#define YSM_MESSAGE_NORMAL	0x01
#define YSM_MESSAGE_FILE	0x03
#define YSM_MESSAGE_URL		0x04
#define YSM_MESSAGE_AUTH	0x06
#define YSM_MESSAGE_AUTHNOT	0x07
#define YSM_MESSAGE_AUTHOK	0x08
#define YSM_MESSAGE_ADDED	0x0c
#define YSM_MESSAGE_PAGER	0x0d
#define YSM_MESSAGE_CONTACTS	0x13
#define YSM_MESSAGE_GREET	0x1a
#define YSM_MESSAGE_GETAWAY	0xe8
#define YSM_MESSAGE_GETOCC	0xe9
#define YSM_MESSAGE_GETNA	0xea
#define YSM_MESSAGE_GETDND	0xeb
#define YSM_MESSAGE_GETFFC	0xec

/* End of Message Types definitions */


/* Definition of ERROR standards */

#define ERROR_CODE		0
#define ERROR_CODE_M		"There has been a code ERROR. Debug!.\n"
#define ERROR_NETWORK		1
#define ERROR_NETWORK_M		"There has been a Network Disconnection!.\n"
#define ERROR_CRITICAL		2
#define ERROR_CRITICAL_M	"There has been a CRITICAL ERROR. duck!\n"

/* End of ERROR Standards definition */

/* Definition of YSM Main Structures */

struct COMMAND
{
	int8_t		*cmd_name;
	int8_t		*cmd_alias;
	int8_t		*cmd_help;
	u_int16_t	cmd_groupid;
	u_int16_t	cmd_margs;
	void		(*cmd_func)(int32_t argc, int8_t **argv);

	/* list related */
	struct COMMAND	*next;
	struct COMMAND	*back;
};

struct YSM_TIMING_INFO
{
	time_t	LastMessage;
 	time_t	Signon;
 	time_t	StatusChange;
};

struct YSM_MAIN_INFO 
{
	char	NickName[MAX_NICK_LEN+1];
	char	FirstName[MAX_NICK_LEN+1];
	char	LastName[MAX_NICK_LEN+1];
	char	email[MAX_NICK_LEN+1];
	char	city[MAX_NICK_LEN+1];
	char	state[MAX_NICK_LEN+1];
	char	gender;
	short	age;	
};

struct YSM_NETWORK_CONNECTION
{
	int32_t		rSocket;
	int8_t		auth_host[MAX_PATH];
	int8_t		cookie_host[MAX_PATH];
	u_int16_t	auth_port;
	u_int16_t	cookie_port;
};

struct YSM_DIRECT_CONNECTION_FILETINFO
{
	u_int32_t	size;
	u_int32_t	totsize;
	int8_t		name[MAX_PEER_FILENAMEL];
	u_int16_t	num;
	u_int16_t	totnum;
	u_int16_t	rPort;	
	int32_t		speed;
	int32_t		kbs;
	time_t		statstime;
	int32_t		statsbytes;
	int32_t		rSocket;
	u_int16_t	lPort;
#define DC_TRANSFERTIMEOUT	30	/* seconds */
	FILE		*fd;
};

struct YSM_DIRECT_CONNECTION
{
	u_int16_t				seq_in;
	u_int16_t				seq_out;
	int32_t					rSocket;
	u_int16_t				rPort;
	u_int32_t				rIP_int;
	u_int32_t				rIP_ext;	
	u_int16_t				version;
	int32_t					rCookie;
#define DC_EXPECTDATA	0x01
#define DC_EXPECTNEG	0x02
#define DC_OUTGOINGNEG	0x04
#define DC_INCOMINGNEG	0x08
#define DC_CONNECTED	0x10
#define DC_TRANSFERING	0x20
#define DC_RECEIVING	0x40
#define DC_ACTIVITY	0x80

	u_int8_t				flags;
	struct YSM_DIRECT_CONNECTION_FILETINFO	finfo; 
};

struct YSM_SPECIAL_STATUS
{
	int8_t	birthday;
	int32_t	IgnoreID;
	int32_t	VisibleID;
	int32_t	InvisibleID;
	int32_t	BudID;
	int32_t	grpID;
};

struct YSM_PROXY_INFO
{
	int8_t		username[MAX_PATH];
	int8_t		password[MAX_PATH];
	int8_t		proxy_host[MAX_PATH];
	u_int16_t	proxy_port;
#define YSM_PROXY_HTTPS		0x01
#define YSM_PROXY_AUTH		0x02
#define YSM_PROXY_RESOLVE	0x04
	u_int8_t	proxy_flags;
};

struct	YSM_PROMPTSTATUS
{
#define FL_OVERWRITTEN	0x01
#define FL_REDRAW	0x02
#define FL_BUSYDISPLAY	0x04
#define FL_COMFORTABLEM	0x08
#define FL_AFKM		0x10
#define FL_CHATM	0x20	
#define FL_AUTOAWAY	0x40
	u_int8_t	flags;
};

struct	YSM_SERVERINFORMATION
{
	u_int16_t	seqnum;
	u_int32_t	onlineslaves;

	/* queued slave scans */
	int32_t		scanqueue;

	/* buddy list information */
	int32_t		blentries;
	int32_t		blgroupsidentries;
	int8_t		*blgroupsid;
	int32_t		blusersidentries;
	int8_t		*blusersid;
	u_int32_t	blysmgroupid;
	u_int16_t	blprivacygroupid;

#define FL_LOGGEDIN		0x01
#define FL_DOWNLOADEDSLAVES	0x02
#define FL_WAITINGUINREGREPLY	0x04
	u_int8_t	flags;
};

struct YSM_FISH_GUI
{
	int32_t		socket;
	fd_set		fish_fds;
	int32_t		max_fish_fd;
	u_int16_t	port;
	u_int8_t	hide_console;
};

struct ENCRYPTION_INFO
{
#define MAX_KEY_LEN	64 /* 512 bits */
	int8_t		strkey[MAX_KEY_LEN+1];
	keyInstance	key_out;
	keyInstance	key_in;
};

struct SLAVE 
{

	u_int32_t			Uin;
	u_int32_t			fprint;
	u_int8_t			caps;
	u_int32_t			ReqID;
	u_int16_t			status;
	u_int16_t			status_flags;
	int8_t				DownloadedFlag;
#define FL_SCANNED	0x01
#define FL_LOG		0x02
#define FL_ALERT	0x04
#define FL_CHAT		0x08
	u_int8_t			flags;
	time_t				LastAFK;
	struct YSM_SPECIAL_STATUS	BudType;
	struct YSM_TIMING_INFO		timing;
	struct YSM_DIRECT_CONNECTION	d_con;
	struct YSM_MAIN_INFO		info;
	struct ENCRYPTION_INFO		crypto;

	/* list related */
	struct SLAVE			*next;	
	struct SLAVE			*back;	
};

struct YSM_MODEL
{ 
        u_int32_t			Uin;
        u_int16_t			status;
	u_int16_t			status_flags;
        int8_t				password[MAX_PWD_LEN];
	u_int8_t			flags;
	time_t				delta;
	struct YSM_MAIN_INFO		info;
	struct YSM_TIMING_INFO		timing;
	struct YSM_PROXY_INFO		proxy;
	struct YSM_DIRECT_CONNECTION	d_con;
	struct YSM_NETWORK_CONNECTION	network;
	struct YSM_FISH_GUI		fishgui;
};

typedef struct _FileMap {
	/* list related */
	struct _FileMap	*next;	
	struct _FileMap	*back;	

        FILE		*fd;
        int32_t		pos;
        int32_t		size;
        int8_t		*data;
} FileMap, *pFileMap;

typedef struct SLAVE YSM_SLAVE;
typedef struct COMMAND YSM_COMMAND;

/* End of Main Structures Definition */


/* Start of Required Exported Variables */
extern struct	YSM_MODEL 		YSM_USER;
extern struct	YSM_SERVERINFORMATION	g_sinfo;
extern struct	YSM_PROMPTSTATUS	g_promptstatus;

extern short	YSM_Redraw_Console;

extern short	YSM_SETTING_MSG_KIND;
extern short	YSM_SETTING_LOGALL;
extern short	YSM_SETTING_NEWLOGSFIRST;
extern short	YSM_SETTING_VERBOSE;
extern short	YSM_SETTING_VERSION_CHECK;
extern short	YSM_SETTING_BEEP;
extern short	YSM_SETTING_SOUNDS;
extern short	YSM_SETTING_AFKMAXSHOWN;
extern short	YSM_SETTING_AFKMINIMUMWAIT;
extern short	YSM_SETTING_AWAYTIME;
extern short	YSM_SETTING_SPOOF;
extern short	YSM_SETTING_WINALERT;
extern short	YSM_SETTING_ANTISOCIAL;
extern short	YSM_SETTING_UPDATENICKS;
extern short 	YSM_SETTING_DCDISABLE;
extern short 	YSM_SETTING_DCLAN;
extern u_int16_t YSM_SETTING_DCPORT1;
extern u_int16_t YSM_SETTING_DCPORT2;
extern char	YSM_SETTING_HOT_KEY_MAXIMIZE;
extern int32_t	YSM_SETTING_FORWARD;
extern char	YSM_SETTING_CHARSET_TRANS[MAX_CHARSET + 4];
extern char	YSM_SETTING_CHARSET_LOCAL[MAX_CHARSET + 4];
extern int8_t	*YSM_SETTING_COLOR_MESSAGE;
extern int8_t	*YSM_SETTING_COLOR_TEXT;
extern int8_t	*YSM_SETTING_COLOR_STATUSCHANGENAME;
extern int8_t	*YSM_SETTING_COLOR_STATUSCHANGESTATUS;
extern int8_t	*YSM_SETTING_COLOR_TEXT2; 
/* End of Exported List */

/* Colors definition Area */
/* Support for Monochrome! */
#define WHITE "\x1B[0;1;37m"

#ifndef YSM_MONOCHROME
#define BLACK "\x1B[0;30m"
#define RED "\x1B[0;31m"
#define GREEN "\x1B[0;32m"
#define BROWN "\x1B[0;33m"
#define BLUE "\x1B[0;34m"
#define MAGENTA "\x1B[0;35m"
#define CYAN "\x1B[0;36m"
#define NORMAL "\x1B[0;37m"

#define BRIGHT_BLACK	"\x1B[0;1;30m"
#define BRIGHT_RED	"\x1B[0;1;31m"
#define BRIGHT_GREEN	"\x1B[0;1;32m"
#define BRIGHT_BROWN	"\x1B[0;1;33m"
#define BRIGHT_BLUE	"\x1B[0;1;34m"
#define BRIGHT_MAGENTA	"\x1B[0;1;35m"
#define BRIGHT_CYAN	"\x1B[0;1;36m"
#define BRIGHT_WHITE	"\x1B[0;1;37m"
#else
#define RED		WHITE
#define GREEN	WHITE
#define BROWN	WHITE
#define BLUE	WHITE
#define MAGENTA	WHITE
#define CYAN	WHITE
#define NORMAL	WHITE

#define BRIGHT_BLACK	WHITE
#define BRIGHT_RED		WHITE
#define BRIGHT_GREEN	WHITE
#define BRIGHT_BROWN	WHITE
#define BRIGHT_BLUE		WHITE
#define BRIGHT_MAGENTA	WHITE
#define BRIGHT_CYAN		WHITE
#define BRIGHT_WHITE	WHITE
#endif

#define CLRSCR		"\033[2J"
#define HOMECUR		"\033[0;0H"
#define BOLD		"\x1B[1m"

#define ICONIFY		"\x1B[2;2;2t"

/* End of Colors definition Area */
